% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{caseflip}
\alias{caseflip}
\title{Flip the case of characters in a string of text \code{x}.}
\usage{
caseflip(x)
}
\arguments{
\item{x}{A string of text (required).}
}
\value{
A character vector.
}
\description{
\code{caseflip} flips the case of all characters 
in a string of text \code{x}.
}
\details{
Internally, \code{caseflip} uses the \code{letters} and \code{LETTERS} 
constants of \strong{base} R and the \code{chartr} function 
for replacing characters in strings of text.
}
\examples{
x <- c("Hello world!", "This is a 1st sentence.", "This is the 2nd sentence.", "The end.")
caseflip(x)
 
}
\seealso{
\code{\link{capitalize}} for converting the case of initial letters; 
\code{chartr} for replacing characters in strings of text.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{collapse_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_chars}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{read_ascii}()},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
