% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num_fun.R
\name{dec2base}
\alias{dec2base}
\title{Convert an integer from decimal notation into a string of numeric digits in some base.}
\usage{
dec2base(x, base = 2)
}
\arguments{
\item{x}{A (required) integer in decimal (base 10) notation 
or corresponding string of digits (i.e., digits 0-9).}

\item{base}{The base or radix of the digits in the output. 
Default: \code{base = 2} (binary).}
}
\value{
A character string of digits (in base notation).
}
\description{
\code{dec2base} converts an integer from its standard decimal notation 
(i.e., using positional numerals with a base or radix of 10) 
into a sequence of numeric symbols (digits) in some other base.
}
\details{
See \code{\link{base_digits}} for the sequence of default digits. 

To prevent erroneous interpretations of numeric outputs, 
\code{dec2base} returns a sequence of digits (as a character string).

\code{dec2base} is the complement of \code{\link{base2dec}}.
}
\examples{
# (a) single numeric input:
dec2base(3)  # base = 2

dec2base(8, base = 2)
dec2base(8, base = 3)
dec2base(8, base = 7)

dec2base(100, base = 5)
dec2base(100, base = 10)
dec2base(100, base = 15)

dec2base(14, base = 14)
dec2base(15, base = 15)
dec2base(16, base = 16)

dec2base(15, base = 16)
dec2base(31, base = 16)
dec2base(47, base = 16)

# (b) single string input:
dec2base("7", base = 2)
dec2base("8", base = 3)

# Extreme values:
dec2base(base2dec(rep("1", 32)))          # 32 x "1"
dec2base(base2dec(c("1", rep("0", 32))))  # 2^32
dec2base(base2dec(rep("1", 33)))          # 33 x "1"
dec2base(base2dec(c("1", rep("0", 33))))  # 2^33

# Non-standard inputs:
dec2base("  ")          # only spaces: NA
dec2base("?")           # no decimal digits: NA
dec2base(" 10 ", 2)     # remove leading and trailing spaces
dec2base("-10", 2)      # handle negative inputs (in character strings)
dec2base(" -- 10", 2)   # handle multiple negations
dec2base("xy -10 ", 2)  # ignore non-decimal digit prefixes

# Note: 
base2dec(dec2base(012340, base =  9), base =  9)
dec2base(base2dec(043210, base = 11), base = 11)

}
\seealso{
\code{\link{base2dec}} converts numerals in some base into decimal numbers; 
\code{\link{as.roman}} converts integers into Roman numerals.

Other numeric functions: 
\code{\link{base2dec}()},
\code{\link{base_digits}},
\code{\link{is_equal}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}

Other utility functions: 
\code{\link{base2dec}()},
\code{\link{base_digits}},
\code{\link{is_equal}()},
\code{\link{is_vect}()},
\code{\link{is_wholenumber}()},
\code{\link{num_as_char}()},
\code{\link{num_as_ordinal}()},
\code{\link{num_equal}()}
}
\concept{numeric functions}
\concept{utility functions}
