% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussmodel.r
\name{gauss_est}
\alias{gauss_est}
\title{Estimate coefficients of a polynomial in Gaussian-based model}
\usage{
gauss_est(deg, mu, sig, data, freq, verbose, stepsize)
}
\arguments{
\item{deg}{A degree of polynomial, which is positive even integer.}

\item{mu}{A mean of Gaussian distribution.}

\item{sig}{A standard deviation of Gaussian distribution, which is positive.}

\item{data}{A numeric vector of a data set to be estimated.}

\item{freq}{A numeric vector of frequencies for a data set \code{data}.
The default value is \code{NULL}, which indicates that all frequencies are
equally one.
If \code{freq} is not \code{NULL}, then it should be the same length as \code{data}, and
all values should be positive integers.}

\item{verbose}{If \code{TRUE}, it shows a detail information about SDP solver.}

\item{stepsize}{It designates the stepsize for SDP solver.
If the problem is easy, i.e., the number of a data set are small and a degree
of a polynomial is small, then, for example, \code{0.9} might be ok.
If it looks difficult, then \code{c(0.5, 0.3)} might work.}
}
\value{
A \code{list} of \code{deg}, \code{mu}, \code{sig}, \code{aic}, \code{accuracy},
\verb{coefficient vector}.
}
\description{
Estimate coefficients of a polynomial in Gaussian-based model:
\deqn{\mathrm{poly}(x, \alpha) N(x; \mu, \sigma^2)},
where \eqn{\alpha} is a coefficient vector, \eqn{\mu} and \eqn{\sigma}
are a mean and a standard deviation of Gaussian distribution:
\deqn{N(x; \mu, \sigma^2) :=\frac{1}{\sigma \sqrt{2\pi}}
 \exp\left(-\frac{(x-\mu)^2}{2\sigma^2}\right) }

Using \code{data} and optionally its frequencies \code{freq},
and a degree of a polynomial,
a mean \code{mu} and a standard deviation \code{sig} of Gausian distribution,
it computes the coefficients of a polynomial, along with
Akaike Information Criterion(AIC) and an accuracy information from
an underlying SDP solver.
In general, the smaller the AIC is, the better the model is.
An \code{accuracy} around \code{1e-7} is a good indication for a computational
result of coefficients estimation.
}
\examples{
rlst <- gauss_est(4, 0, 1, mix2gauss$n200, NULL, FALSE, c(0.7, 0.4))
}
\seealso{
\code{\link[=estimate.gaussmodel]{estimate.gaussmodel()}}
}
