% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussmodel.r
\name{gaussmodel}
\alias{gaussmodel}
\title{Constructor for S3 class \code{gaussmodel}}
\usage{
gaussmodel(data = data, freq = NULL, stepsize = c(0.5, 0.3))
}
\arguments{
\item{data}{A numeric vector of a data set to be estimated.}

\item{freq}{A frequency vector corresponding to the \code{data} vector.
The default value is \code{NULL}, which means all frequencies are one.
If supplied, the length of a vector should be same as \code{data} and
each element should be a nonnegative integer.}

\item{stepsize}{A numeric vector whose element is larger than 0 and smaller
than 1, and decreasing order. The default value is \code{c(0.5, 0.3)}.
If you encounter numerical difficulties, decreasing its values, for example,
to \code{c(0.4, 0.2)}, might help to estimate a model.}
}
\value{
An object of Gaussian-based model \code{gaussmodel}.
}
\description{
This function is a constructor for S3 class \code{gaussmodel},
which represents Gaussian-based model.
It usually takes \code{data} and optionally \code{freq} as arguments and
also optionally \code{stepsize}.
Members of interest in practice are \code{result} and \code{coeffs}, which maintain
the information of estimates and coefficients of polynomials, respectively.
}
\examples{
## Create `gaussmodel` object from a data set `mix2gauss$n200`.
 gmodel <- gaussmodel(mix2gauss$n200)
## Create `gaussmodel` object from a data set `mix2gaussHist$n200p` and
## its frequencies `mix2gaussHist$n200f`.
 gmodel <- gaussmodel(mix2gaussHist$n200p, mix2gaussHist$n200f)
}
\seealso{
\code{\link[=summary.gaussmodel]{summary.gaussmodel()}} \code{\link[=plot.gaussmodel]{plot.gaussmodel()}} \code{\link[=estimate.gaussmodel]{estimate.gaussmodel()}}
}
