% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliaries.r
\name{igamma}
\alias{igamma}
\title{Incomplete Gamma Function}
\usage{
igamma(a, x)
}
\arguments{
\item{a}{A positive numeric vector.}

\item{x}{A nonnegative numeric vector with same length as \code{a}.
length.}
}
\value{
A vector of values of an incomplete gamma function.
}
\description{
Evaluate an incomplete gamma function:
\deqn{\gamma(a, x) = \int_{0}^{x} t^{a-1} e^{-t}dt,}
using SLATEC \code{dgami} in \url{https://netlib.org/slatec/}.
When (\eqn{x > 0} and \eqn{a \ge 0}) or (\eqn{x \ge 0} and \eqn{a > 0}),
compute the result, otherwise the value is \code{NaN}.
}
\examples{
igamma(1, 1)
}
\seealso{
\code{\link[=igammac]{igammac()}}
}
