% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsmodel.R
\name{dsmodel}
\alias{dsmodel}
\title{Defines a model object encapsulating a dynamical system}
\usage{
dsmodel(fun, title = "")
}
\arguments{
\item{fun}{Function with two inputs and two outputs which defines the dynamical system. The output should be a list, preferably with field names x and y.}

\item{title}{A string title for the graph.}
}
\description{
To begin, define a two dimensional function that outputs
a two-dimensional list. For instance:
\code{fun <- function(x,y) list(x,y)}. Then
\code{dsmodel(fun)} will initialize the model.
\strong{Make sure that the function defining your model indeed outputs a \code{list}.}
The model is used to hold the data for graphics.
To display a desired graphic, add the corresponding
feature of type "dsproto" to your model.
}
\details{
Models are constructed
incrementally using the + operator to add features
to the existing dsmodel object. A \code{\link{dsrange}} must be one of the objects added to a model.
}
\examples{
library(dsmodels)

fun <- function(X,Y) {
  list(
    x = X/exp(Y),
    y = Y/exp(X)
  )
}
# Add dsRange to see the actual range.
model <- dsmodel(fun)

dsmodel(function(x,y) {
  list(
    x = x^2,
    y = x/(y+1)
  )
}, title = "Another function!")
}
\seealso{
\code{\link{dsrange}}
}

