% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvalue-asymptotic.R
\name{at_from_os}
\alias{at_from_os}
\title{Asymptotic Test from Outlier Scores}
\usage{
at_from_os(os_train, os_test)
}
\arguments{
\item{os_train}{Outlier scores in training (reference) set.}

\item{os_test}{Outlier scores in test set.}
}
\value{
A named list of class \code{outlier.test} containing:
\itemize{
   \item \code{statistic}: observed WAUC statistic
   \item \code{seq_mct}: sequential Monte Carlo test, when applicable
   \item \code{p_value}: p-value
   \item \code{outlier_scores}: outlier scores from training and test set
}
}
\description{
Test for no adverse shift with outlier scores. Like goodness-of-fit testing,
this two-sample comparison takes the training set, \code{x_train} or
\code{os_train}, as the reference. The method checks whether the test set,
\code{x_test} or \code{os_test}, is worse off relative to this reference
set.
}
\details{
Li and Fine (2010) derives the asymptotic null distribution for the weighted
AUC (WAUC), the test statistic. This approach does not use permutations
and can, as a result, be much faster because it sidesteps the need to refit
the scoring function \code{scorer}. This works well for large samples. The
prefix \emph{at} stands for asymptotic test to tell it apart from the
prefix \emph{pt}, the permutation test.
}
\section{Notes}{

These outlier scores should all be out-of-bag scores to mimic out-of-sample
behaviour. Otherwise, the scores from the training (reference) distribution
are biased (overfitted) whereas those from the test set are not. This
mismatch -- in-sample training scores versus out-of-sample (out-of-bag) test
scores -- would void the validity of the statistical test. A simple fix for
this, without using resampling and/or permutations, is to get the training
(reference) scores from a fresh (unused) validation set.
}

\examples{
\donttest{
library(dsos)
set.seed(12345)
os_train <- rnorm(n = 100)
os_test <- rnorm(n = 100)
test_result <- at_from_os(os_train, os_test)
test_result
}

}
\references{
Kamulete, V. M. (2022).
\emph{Test for non-negligible adverse shifts}.
In The 38th Conference on Uncertainty in Artificial Intelligence. PMLR.

Gandy, A. (2009).
\emph{Sequential implementation of Monte Carlo tests with uniformly bounded resampling risk}.
Journal of the American Statistical Association, 104(488), 1504-1511.

Li, J., & Fine, J. P. (2010).
\emph{Weighted area under the receiver operating characteristic curve and its application to gene selection}.
Journal of the Royal Statistical Society: Series C (Applied Statistics), 59(4), 673-692.
}
\seealso{
[at_oob()] for variant requiring a scoring function.
[pt_from_os()] for permutation test with the outlier scores.

Other asymptotic-test: 
\code{\link{at_oob}()}
}
\concept{asymptotic-test}
