% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-permutations.R
\name{score_rd}
\alias{score_rd}
\title{Predict Out-of-bag Errors (Residuals)}
\usage{
score_rd(x_train, x_test, n_trees = 500L, response_name = "label")
}
\arguments{
\item{x_train}{Training (reference) sample.}

\item{x_test}{Test sample.}

\item{n_trees}{The number of trees in random forest.}

\item{response_name}{The column name of the categorical outcome to predict.}
}
\value{
A named list or object of class \code{outlier.test} containing:
\itemize{
   \item \code{train}: vector of scores in training set
   \item \code{test}: vector of scores in test set
}
}
\description{
Predict out-of-bag errors (residuals) using random forest with the
\pkg{ranger} package. The prefix \emph{rd} stands for residual diagnostic,
the relevant notion of outlyingness. This function is useful to test for
dataset shift via prediction errors from the underlying supervised
algorithm.
}
\details{
\code{score_rd} first fits to the training data and uses out-of-bag
predictions to estimate errors (residuals) for this reference sample. Then it
leverages out-of-sample predictions to calculate errors for the test set.
As a result, estimating p-value via permutations does not require refitting
the algorithm for every permutation. See Hediger et al. (2022) for details
on this approach.
}
\section{Notes}{

Residuals traditionally underpin diagnostics (misspecification) tests in
supervised learning. For a contemporaneous example of this approach using
machine learning, see Janková et al. (2020) and references therein.
}

\examples{
\donttest{
library(dsos)
set.seed(12345)
data(iris)
idx <- sample(nrow(iris), 2 / 3 * nrow(iris))
xy_train <- iris[idx, ]
xy_test <- iris[-idx, ]
score_rd(xy_train, xy_test, n_trees = 500L, response_name = "Species")
}

}
\references{
Janková, J., Shah, R. D., Bühlmann, P., & Samworth, R. J. (2020).
\emph{Goodness-of-fit testing in high dimensional generalized linear models}.
Journal of the Royal Statistical Society: Series B (Statistical Methodology), 82(3), 773-795.

Hediger, S., Michel, L., & Näf, J. (2022).
\emph{On the use of random forest for two-sample testing}.
Computational Statistics & Data Analysis, 170, 107435.
}
\seealso{
Other scoring: 
\code{\link{score_cp}()},
\code{\link{score_od}()},
\code{\link{score_rue}()}
}
\concept{scoring}
