% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotComb.R
\name{plotComb}
\alias{plotComb}
\title{Plot the combination scores using the training model}
\usage{
plotComb(model, status)
}
\arguments{
\item{model}{a \code{list} object where the parameters from the training
model are saved.}

\item{status}{a \code{factor} vector that includes the actual disease
status of the patients}
}
\value{
A \code{data.frame} plots
}
\description{
The \code{plotComb} a function that generates plots from the
training model. The function takes argument model. The outputs of the
function are three different plots generated from the combination scores.
}
\examples{

# call data
data(laparoscopy)

# define the function parameters
markers <- laparoscopy[, -1]
status <- factor(laparoscopy$group, levels = c("not_needed", "needed"))
event <- "needed"

score1 <- linComb(
  markers = markers, status = status, event = event,
  method = "scoring", resample = "none",
  standardize = "none", direction = "<", cutoff.method = "Youden"
)

plotComb(score1, status)

score2 <- nonlinComb(
  markers = markers, status = status, event = event,
  method = "nsgam", resample = "cv", include.interact = FALSE, direction = "<",
  standardize = "zScore", cutoff.method = "Youden"
)

plot.score2 <- plotComb(score2, status)

score3 <- mathComb(
  markers = markers, status = status, event = event,
  method = "distance", distance = "euclidean", direction = "auto",
  standardize = "tScore", cutoff.method = "Youden"
)

plot.score3 <- plotComb(score3, status)

}
\author{
Serra Ilayda Yerlitas, Serra Bersan Gengec, Necla Kochan,
Gozde Erturk Zararsiz, Selcuk Korkmaz, Gokmen Zararsiz
}
