% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R, R/set.R
\name{dtt_date}
\alias{dtt_date}
\alias{dtt_date<-}
\alias{dtt_date.integer}
\alias{dtt_date.double}
\alias{dtt_date.character}
\alias{dtt_date.Date}
\alias{dtt_date.POSIXct}
\alias{dtt_date.hms}
\alias{dtt_date<-.Date}
\alias{dtt_date<-.POSIXct}
\alias{dtt_set_date}
\title{Floor Date}
\usage{
dtt_date(x, ...)

dtt_date(x) <- value

\method{dtt_date}{integer}(x, origin = as.Date("1970-01-01"), ...)

\method{dtt_date}{double}(x, origin = as.Date("1970-01-01"), ...)

\method{dtt_date}{character}(x, ...)

\method{dtt_date}{Date}(x, ...)

\method{dtt_date}{POSIXct}(x, ...)

\method{dtt_date}{hms}(x, ...)

\method{dtt_date}{Date}(x) <- value

\method{dtt_date}{POSIXct}(x) <- value

dtt_set_date(x, value)
}
\arguments{
\item{x}{A vector.}

\item{...}{Unused.}

\item{value}{A date vector.}

\item{origin}{Origin date.}
}
\value{
A floored Date vector.
}
\description{
Coerces vectors to floored Date vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{dtt_date(integer)}: Coerce integer vector to a floored Date vector

\item \code{dtt_date(double)}: Coerce double vector to a floored Date vector

\item \code{dtt_date(character)}: Coerce character vector to a floored Date vector

\item \code{dtt_date(Date)}: Coerce Date vector to a floored Date vector

\item \code{dtt_date(POSIXct)}: Coerce POSIXct vector to a floored Date vector

\item \code{dtt_date(hms)}: Coerce hms vector to a floored Date vector

}}
\section{Functions}{
\itemize{
\item \code{dtt_date(Date) <- value}: Set date values for a Date vector

\item \code{dtt_date(POSIXct) <- value}: Set date values for a POSIXct vector

}}
\examples{
dtt_date(1L)
dtt_date(-1)
dtt_date("2000-01-01")
as.Date(as.POSIXct("2019-05-01", tz = "Etc/GMT-8"))
dtt_date(as.POSIXct("2019-05-01", tz = "Etc/GMT-8"))
dtt_date(hms::as_hms("23:59:59"))
dtt_date(hms::as_hms("24:00:00"))
}
\seealso{
Other floor: 
\code{\link{dtt_date_time}()},
\code{\link{dtt_excel_to_date}()},
\code{\link{dtt_floor}()},
\code{\link{dtt_floored}()},
\code{\link{dtt_set_time}()}
}
\concept{floor}
