% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date-time-from-ints.R
\name{dtt_date_time_from_ints}
\alias{dtt_date_time_from_ints}
\title{Create Date Times from Integers}
\usage{
dtt_date_time_from_ints(
  year = 1972L,
  month = 1L,
  day = 1L,
  hour = 0L,
  minute = 0L,
  second = 0L,
  tz = dtt_default_tz()
)
}
\arguments{
\item{year}{An integer of the year. The default value is 1972.}

\item{month}{An integer of the month between 1 and 12. The default value is
the 1st month.}

\item{day}{An integer of the day between 1 and 31. The default value is the
1st day.}

\item{hour}{An integer of the hour between 0 and 23.The default value is hour
zero.}

\item{minute}{An integer of the minute between 0 to 59. The default value is
minute zero.}

\item{second}{An integer of the second between 0 to 59. The default value is
second zero.}

\item{tz}{A string of the time zone.}
}
\value{
A POSIXct vector
}
\description{
Create date object from vectors of year, month and day values.
}
\details{
This can be very helpful when needing to create a date time column
in a data frame from year, month, day, hour, minute, and second columns.
Vectors must all be the same length or be of length one.
}
\examples{
dtt_date_time_from_ints(
  year = 1991,
  month = 07,
  day = 23,
  hour = 06,
  minute = 25,
  second = 0,
  tz = "Etc/GMT+8"
)

dtt_date_time_from_ints(
  year = c(1991, 1992, 1993),
  month = c(07, 07, 07),
  day = c(23, 24, 21),
  hour = c(06, 05, 07),
  minute = c(25, 24, 15),
  second = c(0, 0, 0),
  tz = "Etc/GMT+8"
)

year <- c(1991, 1992, 1993)
month <- c(07, 08, 09)
day <- c(23, 24, 21)
hour <- c(06, 05, 07)
minute <- c(25, 24, 15)
second <- 30
dtt_date_time_from_ints(year, month, day, hour, minute, second)

dtt_date_time_from_ints(year, month, day)
}
\seealso{
Other creates: 
\code{\link{dtt_date_from_ints}()},
\code{\link{dtt_time_from_ints}()}
}
\concept{creates}
