% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/excel_to_date_time.R
\name{dtt_excel_to_date_time}
\alias{dtt_excel_to_date_time}
\title{Convert Excel date times to date times.}
\usage{
dtt_excel_to_date_time(x, tz = dtt_default_tz(), modern = TRUE, ...)
}
\arguments{
\item{x}{A vector of numbers to convert.}

\item{tz}{A string of the time zone.}

\item{modern}{A flag specifying whether to use the modern or old Excel date
system.}

\item{...}{Unused.}
}
\value{
A floored POSIXct vector.
}
\description{
Converts Excel serial date times to date time class.
}
\details{
Defaults to the modern Excel date encoding system. Excel for Mac
2008 and earlier Mac versions of Excel use a different date system. If the
date 2016-01-01 is represented by 42370, it's the modern system. If it's
40908, it's the old system.
}
\examples{
dtt_excel_to_date_time(42370.1234)
dtt_excel_to_date_time(c(1000.1145, 43397.84578))
dtt_excel_to_date_time(45324.1234, tz = "UTC")
dtt_excel_to_date_time(42370.1234, modern = FALSE)
}
