% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.dtw.R
\name{dtwPlotDensity}
\alias{dtwPlotDensity}
\title{Display the cumulative cost density with the warping path overimposed}
\usage{
dtwPlotDensity(
  d,
  normalize = FALSE,
  xlab = "Query index",
  ylab = "Reference index",
  ...
)
}
\arguments{
\item{d}{an alignment result, object of class \code{dtw}}

\item{normalize}{show per-step average cost instead of cumulative cost}

\item{xlab}{label for the query axis}

\item{ylab}{label for the reference axis}

\item{...}{additional parameters forwarded to plotting functions}
}
\description{
The plot is based on the cumulative cost matrix. It displays the optimal alignment
as a "ridge" in the global cost landscape.
}
\details{
The alignment must have been
constructed with the \code{keep.internals=TRUE} parameter set.

If \code{normalize} is \code{TRUE}, the \emph{average} cost per step is
plotted instead of the cumulative one. Step averaging depends on the
\code{\link[=stepPattern]{stepPattern()}} used.
}
\examples{

## A study of the "Itakura" parallelogram
##
## A widely held misconception is that the "Itakura parallelogram" (as
## described in the original article) is a global constraint.  Instead,
## it arises from local slope restrictions. Anyway, an "itakuraWindow",
## is provided in this package. A comparison between the two follows.

## The local constraint: three sides of the parallelogram are seen
idx<-seq(0,6.28,len=100);
query<-sin(idx)+runif(100)/10;
reference<-cos(idx)

ita <- dtw(query,reference,keep=TRUE,step=typeIIIc)
dtwPlotDensity(ita, main="Slope-limited asymmetric step (Itakura)")

## Symmetric step with global parallelogram-shaped constraint. Note how
## long (>2 steps) horizontal stretches are allowed within the window.

dtw(query,reference,keep=TRUE,window=itakuraWindow)->ita;
dtwPlotDensity(ita,
        main="Symmetric step with Itakura parallelogram window")

}
\seealso{
Other plot: 
\code{\link{dtwPlotThreeWay}()},
\code{\link{dtwPlotTwoWay}()},
\code{\link{dtwPlot}()}
}
\concept{plot}
