% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/twdtw.R
\docType{methods}
\name{twdtw}
\alias{twdtw}
\title{Multidimensional Time-Weighted DTW Alignment}
\usage{
twdtw(query, template, weight = NULL, dist.method = "Euclidean",
  theta = NULL, alpha = NULL, beta = NULL, n.alignments = NULL,
  span = NULL, step.matrix = symmetric1, keep = FALSE,
  query.name = NULL)
}
\arguments{
\item{query}{A \link[zoo]{zoo} object with a query time series.}

\item{template}{A \link[zoo]{zoo} object with a template time series similar
to \code{query}. The \code{template} must have the same number of attributes
and be equal to or longer than the \code{query},
\emph{i.e.} \code{nrow(query)<=nrow(template)}.}

\item{weight}{A character. ''linear'' for linear weight or ''logistic''
for logistic weight. Default is NULL that runs the original dtw method,
\emph{i.e.} without time weight.}

\item{dist.method}{A character. Method to derive the local cost matrix.
Default is ''Euclidean'' See \code{\link[proxy]{dist}} in package
\pkg{proxy}.}

\item{theta}{A number. Parameter for ''linear'' time weight. For \code{theta=1}
the time weight is equal to the number of elapsed days.}

\item{alpha}{A number. The steepness of logistic weight.}

\item{beta}{A number. The midpoint of logistic weight.}

\item{n.alignments}{An integer. The maximun number of alignments to
perform. NULL will return all possible alignments.}

\item{span}{Span between two points of minimum in days, \emph{i.e.} the minimum
interval between two alignments, for details see [1]}

\item{step.matrix}{see \code{\link[dtw]{stepPattern}} in package \pkg{dtw} [2]}

\item{keep}{preserves the cost matrix, inputs, and other internal structures.
Default is FALSE}

\item{query.name}{A query identification.}
}
\value{
An object of class \code{\link[dtwSat]{dtwSat-class}}
}
\description{
This function performs a multidimensional Time-Weighted DTW
analysis and retrieves the alignments of a query within a time series.
}
\examples{
names(query.list)
query.name = "Soybean"
alig = twdtw(query.list[[query.name]], template, weight = "logistic",
       alpha = 0.1, beta = 100, n.alignments=4, query.name=query.name)
alig
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\references{
[1] M\"uller, M. (2007). Dynamic Time Warping. In Information Retrieval for Music
and Motion (pp. 79-84). London: Springer London, Limited.

[2] Giorgino, T. (2009). Computing and Visualizing Dynamic Time Warping Alignments in R:
The dtw Package. Journal of Statistical Software, 31, 1-24.
}
\seealso{
\code{\link[dtwSat]{mtwdtw}}, \code{\link[dtwSat]{dtwSat-class}}
}

