% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/miscellaneous.R
\docType{methods}
\name{waveletSmoothing}
\alias{waveletSmoothing}
\title{Wavelet filter}
\usage{
waveletSmoothing(x, timeline = NULL, frequency = NULL, wf = "la8",
  J = 1, boundary = "periodic", ...)
}
\arguments{
\item{x}{A \code{\link[zoo]{zoo}} object with the time series}

\item{timeline}{A vector of dates for the output time series.
It must have a regular frequency.}

\item{frequency}{The frequncy for the output time series}

\item{wf}{Name of the wavelet filter used in the decomposition.
Default is "la8"}

\item{J}{Specifies the depth of the decomposition. This must be a number
less than or equal to log(length(x),2). Default is 1}

\item{boundary}{Character string specifying the boundary condition.
Default is "periodic". See parameters of \code{\link[waveslim]{mra}}.}

\item{...}{see parameters of \code{\link[waveslim]{mra}} in the
packege \pkg{waveslim}}
}
\value{
object of class \code{\link[zoo]{zoo}}
}
\description{
This function performs a smoothing algorithm to
the time series. It computes a discreat wavelet
smoothing for each dimension in the imput time series.
}
\examples{
## Wavelet filter
sy = waveletSmoothing(x=template, frequency=16, wf = "la8", J=1,
     boundary = "periodic")
plot(template$evi, xlab="Time", ylab="EVI")
lines(sy$evi, col="red")

## Plot raw EVI and filtered EVI
#require(ggplot2)
#evi = merge(Raw=zoo(template$evi), Wavelet=zoo(sy$evi))
#gp = autoplot(evi, facets = NULL) + xlab("Time")
#gp

## Plot all filter bands
#require(ggplot2)
#gp = autoplot(sy, facets = NULL) + xlab("Time")
#gp
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\link[waveslim]{mra}
}

