% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-crossValidation.R, R/methods.R
\docType{methods}
\name{twdtwCrossValidation-class}
\alias{twdtwCrossValidation-class}
\alias{twdtwCrossValidation}
\alias{show,twdtwCrossValidation-method}
\alias{summary,twdtwCrossValidation-method}
\title{class "twdtwCrossValidation"}
\usage{
\S4method{show}{twdtwCrossValidation}(object)

\S4method{summary}{twdtwCrossValidation}(object, conf.int = 0.95, ...)
}
\arguments{
\item{object}{an object of class twdtwCrossValidation.}

\item{conf.int}{specifies the confidence level (0-1) for interval estimation of the 
population mean. For more details see \code{\link[ggplot2]{mean_cl_boot}}.}

\item{...}{Other arguments. Not used.}
}
\description{
This class stores the results of the cross-validation.
}
\section{Slots }{

\describe{
 \item{\code{partitions}:}{A list with the indices of time series used for training.}
 \item{\code{accuracy}:}{A list with the accuracy and other TWDTW information for each 
 data partitions.}
}
}

\examples{
\dontrun{
# Data folder 
data_folder = system.file("lucc_MT/data", package = "dtwSat")

# Read dates 
dates = scan(paste(data_folder,"timeline", sep = "/"), what = "dates")

# Read raster time series 
evi = brick(paste(data_folder,"evi.tif", sep = "/"))
raster_timeseries = twdtwRaster(evi, timeline = dates)

# Read field samples 
field_samples = read.csv(paste(data_folder,"samples.csv", sep = "/")) 
table(field_samples[["label"]])

# Read field samples projection 
proj_str = scan(paste(data_folder,"samples_projection", sep = "/"), 
     what = "character")

# Get sample time series from raster time series 
field_samples_ts = getTimeSeries(raster_timeseries, 
     y = field_samples, proj4string = proj_str)
field_samples_ts

# Run cross validation
set.seed(1)
# Define TWDTW weight function 
log_fun = logisticWeight(alpha=-0.1, beta=50) 
cross_validation = twdtwCrossValidate(field_samples_ts, times=3, p=0.1, 
                          freq = 8, formula = y ~ s(x, bs="cc"), weight.fun = log_fun)
cross_validation

summary(cross_validation)

plot(cross_validation)

}
}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwMatches-class}},
\code{\link[dtwSat]{createPatterns}}, and 
\code{\link[dtwSat]{twdtwApply}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
