% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CLUSTERING-compare-clusterings.R
\name{compare_clusterings_configs}
\alias{compare_clusterings_configs}
\title{Create clustering configurations.}
\usage{
compare_clusterings_configs(types = c("p", "h", "f"), k = 2L,
  controls = NULL, preprocs = pdc_configs("preproc", none = list()),
  distances = pdc_configs("distance", dtw_basic = list()),
  centroids = pdc_configs("centroid", default = list()))
}
\arguments{
\item{types}{Clustering types. It must be any combination of (possibly abbreviated): partitional,
hierarchical, fuzzy, tadpole.}

\item{k}{A numeric vector with one or more elements specifying the number of clusters to test.}

\item{controls}{A named list of \link{tsclust-controls}. \code{NULL} means defaults. See details.}

\item{preprocs}{Preprocessing configurations. See details.}

\item{distances}{Distance configurations. See details.}

\item{centroids}{Centroid configurations. See details.}
}
\value{
A list for each clustering type, each of which includes a data frame with the computed and merged
configurations. Each data frame has an extra attribute \code{num.configs} specifying the number of
configurations.
}
\description{
Create configurations for \code{\link[=compare_clusterings]{compare_clusterings()}}
}
\details{
This function uses \code{\link[base:expand.grid]{base::expand.grid()}} and \code{\link[base:merge]{base::merge()}}.

Preprocessing, distance and centroid configurations are specified with the helper function
\code{\link[=pdc_configs]{pdc_configs()}}, refer to the examples in \code{\link[=compare_clusterings]{compare_clusterings()}} to see how this is used.

The controls list may be specified with the usual \link{tsclust-controls} functions. The names  of
the list must correspond to "partitional", "hierarchical", "fuzzy" or "tadpole" clustering.
Again, please refer to the examples in \code{\link[=compare_clusterings]{compare_clusterings()}}.
}
