% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relational.R
\name{rel_aggregate}
\alias{rel_aggregate}
\title{Lazily aggregate a DuckDB relation object}
\usage{
rel_aggregate(rel, groups, aggregates)
}
\arguments{
\item{rel}{the DuckDB relation object}

\item{groups}{a list of DuckDB expressions to group by}

\item{aggregates}{a (optionally named) list of DuckDB expressions with aggregates to compute}
}
\value{
the now aggregated \code{duckdb_relation} object
}
\description{
Lazily aggregate a DuckDB relation object
}
\examples{
con <- DBI::dbConnect(duckdb())
rel <- rel_from_df(con, mtcars)
aggrs <- list(avg_hp = expr_function("avg", list(expr_reference("hp"))))
rel2 <- rel_aggregate(rel, list(expr_reference("cyl")), aggrs)
}
