# Generated by 02-duckplyr_df-methods.R
#' @export
pull.duckplyr_df <- function(.data, var = -1, name = NULL, ...) {
  # dplyr implementation
  my_var <- tidyselect::vars_pull(names(.data), !!enquo(var))
  my_name <- enquo(name)
  if (!quo_is_null(my_name)) {
    my_name <- tidyselect::vars_pull(names(.data), !!my_name)
    my_var <- c(my_name, my_var)
  }

  loc <- set_names(match(my_var, names(.data)), my_var)

  exprs <- exprs_from_loc(.data, loc)

  rel_try(
    "Can't use relational with zero-column result set." = (length(exprs) == 0),
    {
      rel <- duckdb_rel_from_df(.data)
      out_rel <- rel_project(rel, exprs)
      out <- rel_to_df(out_rel)
      out <- tibble::deframe(out)
      return(out)
    }
  )

  # dplyr forward
  pull <- dplyr$pull.data.frame
  out <- pull(.data, {{ var }}, {{ name }}, ...)
  return(out)

  # dplyr implementation
  var <- tidyselect::vars_pull(names(.data), !!enquo(var))
  name <- enquo(name)
  if (quo_is_null(name)) {
    return(.data[[var]])
  }
  name <- tidyselect::vars_pull(names(.data), !!name)
  set_names(.data[[var]], nm = .data[[name]])
}

duckplyr_pull <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- pull(.data, ...)
  out
}
