# Generated by 02-duckplyr_df-methods.R
#' @export
sample_frac.duckplyr_df <- function(tbl, size = 1, replace = FALSE, weight = NULL, .env = NULL, ...) {
  # Our implementation
  rel_try(
    "No relational implementation for sample_frac()" = TRUE,
    {
      return(out)
    }
  )

  # dplyr forward
  sample_frac <- dplyr$sample_frac.data.frame
  out <- sample_frac(tbl, {{ size }}, replace, {{ weight }}, .env, ...)
  return(out)

  # dplyr implementation
  if (!is_null(.env)) {
    inform("`.env` is deprecated and no longer has any effect")
  }

  size <- enquo(size)
  weight <- enquo(weight)

  dplyr_local_error_call()
  slice(tbl, local({
    size <- round(n() * check_frac(!!size, replace = replace))
    sample.int(n(), size, replace = replace, prob = !!weight)
  }))
}

duckplyr_sample_frac <- function(tbl, ...) {
  try_fetch(
    tbl <- as_duckplyr_df(tbl),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- sample_frac(tbl, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
