% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{config}
\alias{config}
\title{Configuration options}
\description{
The behavior of duckplyr can be fine-tuned with several environment variables,
and one option.
}
\section{Options}{


\code{duckdb.materialize_message}: Set to \code{FALSE} to turn off diagnostic output from duckdb
on data frame materialization.
Currenty set to \code{TRUE} when duckplyr is loaded.
}

\section{Environment variables}{


\code{DUCKPLYR_OUTPUT_ORDER}: If \code{TRUE}, row output order is preserved.
The default may change the row order where dplyr would keep it stable.

\code{DUCKPLYR_FORCE}: If \code{TRUE}, fail if duckdb cannot handle a request.

\code{DUCKPLYR_FALLBACK_INFO}: If \code{TRUE}, print a message when a fallback to dplyr occurs
because duckdb cannot handle a request.

\code{DUCKPLYR_CHECK_ROUNDTRIP}: If \code{TRUE}, check if all columns are roundtripped perfectly
when creating a relational object from a data frame,
This is slow, and mostly useful for debugging.
The default is to check roundtrip of attributes.

\code{DUCKPLYR_EXPERIMENTAL}: If \code{TRUE}, pass \code{experimental = TRUE}
to certain duckdb functions.
Currently unused.

\code{DUCKPLYR_METHODS_OVERWRITE}: If \code{TRUE}, call \code{methods_overwrite()}
when the package is loaded.

See \link{fallback} for more options related to logging and uploading of fallback events.
}

\examples{
# options(duckdb.materialize_message = FALSE)
data.frame(a = 3:1) \%>\%
  as_duckplyr_df() \%>\%
  inner_join(data.frame(a = 1:4), by = "a")

rlang::with_options(duckdb.materialize_message = FALSE, {
  data.frame(a = 3:1) \%>\%
    as_duckplyr_df() \%>\%
    inner_join(data.frame(a = 1:4), by = "a") \%>\%
    print()
})

# Sys.setenv(DUCKPLYR_OUTPUT_ORDER = TRUE)
data.frame(a = 3:1) \%>\%
  as_duckplyr_df() \%>\%
  inner_join(data.frame(a = 1:4), by = "a")

withr::with_envvar(c(DUCKPLYR_OUTPUT_ORDER = "TRUE"), {
  data.frame(a = 3:1) \%>\%
    as_duckplyr_df() \%>\%
    inner_join(data.frame(a = 1:4), by = "a")
})

# Sys.setenv(DUCKPLYR_FORCE = TRUE)
add_one <- function(x) {
  x + 1
}

data.frame(a = 3:1) \%>\%
  as_duckplyr_df() \%>\%
  mutate(b = add_one(a))

try(withr::with_envvar(c(DUCKPLYR_FORCE = "TRUE"), {
  data.frame(a = 3:1) \%>\%
    as_duckplyr_df() \%>\%
    mutate(b = add_one(a))
}))

# Sys.setenv(DUCKPLYR_FALLBACK_INFO = TRUE)
withr::with_envvar(c(DUCKPLYR_FALLBACK_INFO = "TRUE"), {
  data.frame(a = 3:1) \%>\%
    as_duckplyr_df() \%>\%
    mutate(b = add_one(a))
})
}
