% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io-.R, R/io-csv.R, R/io-parquet.R
\name{df_from_file}
\alias{df_from_file}
\alias{duckplyr_df_from_file}
\alias{df_from_csv}
\alias{duckplyr_df_from_csv}
\alias{df_from_parquet}
\alias{duckplyr_df_from_parquet}
\alias{df_to_parquet}
\title{Read Parquet, CSV, and other files using DuckDB}
\usage{
df_from_file(path, table_function, ..., options = list(), class = NULL)

duckplyr_df_from_file(
  path,
  table_function,
  ...,
  options = list(),
  class = NULL
)

df_from_csv(path, ..., options = list(), class = NULL)

duckplyr_df_from_csv(path, ..., options = list(), class = NULL)

df_from_parquet(path, ..., options = list(), class = NULL)

duckplyr_df_from_parquet(path, ..., options = list(), class = NULL)

df_to_parquet(data, path)
}
\arguments{
\item{path}{Path to files, glob patterns \code{*} and \verb{?} are supported.}

\item{table_function}{The name of a table-valued
DuckDB function such as \code{"read_parquet"},
\code{"read_csv"}, \code{"read_csv_auto"} or \code{"read_json"}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{options}{Arguments to the DuckDB function
indicated by \code{table_function}.}

\item{class}{The class of the output.
By default, a tibble is created.
The returned object will always be a data frame.
Use \code{class = "data.frame"} or \code{class = character()}
to create a plain data frame.}

\item{data}{A data frame to be written to disk.}
}
\value{
A data frame for \code{df_from_file()}, or a \code{duckplyr_df} for
\code{duckplyr_df_from_file()}, extended by the provided \code{class}.
}
\description{
\code{df_from_file()} uses arbitrary table functions to read data.
See \url{https://duckdb.org/docs/data/overview} for a documentation
of the available functions and their options.
To read multiple files with the same schema,
pass a wildcard or a character vector to the \code{path} argument,

\code{duckplyr_df_from_file()} is a thin wrapper around \code{df_from_file()}
that calls \code{as_duckplyr_df()} on the output.

These functions ingest data from a file using a table function.
The results are transparently converted to a data frame, but the data is only read when
the resulting data frame is actually accessed.

\code{df_from_csv()} reads a CSV file using the \code{read_csv_auto()} table function.

\code{duckplyr_df_from_csv()} is a thin wrapper around \code{df_from_csv()}
that calls \code{as_duckplyr_df()} on the output.

\code{df_from_parquet()} reads a Parquet file using the \code{read_parquet()} table function.

\code{duckplyr_df_from_parquet()} is a thin wrapper around \code{df_from_parquet()}
that calls \code{as_duckplyr_df()} on the output.

\code{df_to_parquet()} writes a data frame to a Parquet file via DuckDB.
If the data frame is a \code{duckplyr_df}, the materialization occurs outside of R.
An existing file will be overwritten.
This function requires duckdb >= 0.10.0.
}
\examples{
# Create simple CSV file
path <- tempfile("duckplyr_test_", fileext = ".csv")
write.csv(data.frame(a = 1:3, b = letters[4:6]), path, row.names = FALSE)

# Reading is immediate
df <- df_from_csv(path)

# Materialization only upon access
names(df)
df$a

# Return as tibble, specify column types:
df_from_file(
  path,
  "read_csv",
  options = list(delim = ",", types = list(c("DOUBLE", "VARCHAR"))),
  class = class(tibble())
)

# Read multiple file at once
path2 <- tempfile("duckplyr_test_", fileext = ".csv")
write.csv(data.frame(a = 4:6, b = letters[7:9]), path2, row.names = FALSE)

duckplyr_df_from_csv(file.path(tempdir(), "duckplyr_test_*.csv"))

unlink(c(path, path2))

# Write a Parquet file:
path_parquet <- tempfile(fileext = ".parquet")
df_to_parquet(df, path_parquet)

# With a duckplyr_df, the materialization occurs outside of R:
df \%>\%
  as_duckplyr_df() \%>\%
  mutate(b = a + 1) \%>\%
  df_to_parquet(path_parquet)

duckplyr_df_from_parquet(path_parquet)

unlink(path_parquet)
}
