% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/left_join-rd.R, R/left_join.R
\name{left_join.duckplyr_df}
\alias{left_join.duckplyr_df}
\title{Left join}
\usage{
\method{left_join}{duckplyr_df}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  ...,
  keep = NULL,
  na_matches = c("na", "never"),
  multiple = "all",
  unmatched = "drop",
  relationship = NULL
)
}
\arguments{
\item{x, y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{by}{A join specification created with \code{\link[dplyr:join_by]{join_by()}}, or a character
vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so
that you can check they're correct; suppress the message by supplying \code{by}
explicitly.

To join on different variables between \code{x} and \code{y}, use a \code{\link[dplyr:join_by]{join_by()}}
specification. For example, \code{join_by(a == b)} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a \code{\link[dplyr:join_by]{join_by()}} specification with
multiple expressions. For example, \code{join_by(a == b, c == d)} will match
\code{x$a} to \code{y$b} and \code{x$c} to \code{y$d}. If the column names are the same between
\code{x} and \code{y}, you can shorten this by listing only the variable names, like
\code{join_by(a, c)}.

\code{\link[dplyr:join_by]{join_by()}} can also be used to perform inequality, rolling, and overlap
joins. See the documentation at \link[dplyr:join_by]{?join_by} for details on
these types of joins.

For simple equality joins, you can alternatively specify a character vector
of variable names to join by. For example, \code{by = c("a", "b")} joins \code{x$a}
to \code{y$a} and \code{x$b} to \code{y$b}. If variable names differ between \code{x} and \code{y},
use a named character vector like \code{by = c("x_a" = "y_a", "x_b" = "y_b")}.

To perform a cross-join, generating all combinations of \code{x} and \code{y}, see
\code{\link[dplyr:cross_join]{cross_join()}}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{...}{Other parameters passed onto methods.}

\item{keep}{Should the join keys from both \code{x} and \code{y} be preserved in the
output?
\itemize{
\item If \code{NULL}, the default, joins on equality retain only the keys from \code{x},
while joins on inequality retain the keys from both inputs.
\item If \code{TRUE}, all keys from both inputs are retained.
\item If \code{FALSE}, only keys from \code{x} are retained. For right and full joins,
the data in key columns corresponding to rows that only exist in \code{y} are
merged into the key columns from \code{x}. Can't be used when joining on
inequality conditions.
}}

\item{na_matches}{Should two \code{NA} or two \code{NaN} values match?
\itemize{
\item \code{"na"}, the default, treats two \code{NA} or two \code{NaN} values as equal, like
\code{\%in\%}, \code{\link[=match]{match()}}, and \code{\link[=merge]{merge()}}.
\item \code{"never"} treats two \code{NA} or two \code{NaN} values as different, and will
never match them together or to any other values. This is similar to joins
for database sources and to \code{base::merge(incomparables = NA)}.
}}

\item{multiple}{Handling of rows in \code{x} with multiple matches in \code{y}.
For each row of \code{x}:
\itemize{
\item \code{"all"}, the default, returns every match detected in \code{y}. This is the
same behavior as SQL.
\item \code{"any"} returns one match detected in \code{y}, with no guarantees on which
match will be returned. It is often faster than \code{"first"} and \code{"last"}
if you just need to detect if there is at least one match.
\item \code{"first"} returns the first match detected in \code{y}.
\item \code{"last"} returns the last match detected in \code{y}.
}}

\item{unmatched}{How should unmatched keys that would result in dropped rows
be handled?
\itemize{
\item \code{"drop"} drops unmatched keys from the result.
\item \code{"error"} throws an error if unmatched keys are detected.
}

\code{unmatched} is intended to protect you from accidentally dropping rows
during a join. It only checks for unmatched keys in the input that could
potentially drop rows.
\itemize{
\item For left joins, it checks \code{y}.
\item For right joins, it checks \code{x}.
\item For inner joins, it checks both \code{x} and \code{y}. In this case, \code{unmatched} is
also allowed to be a character vector of length 2 to specify the behavior
for \code{x} and \code{y} independently.
}}

\item{relationship}{Handling of the expected relationship between the keys of
\code{x} and \code{y}. If the expectations chosen from the list below are
invalidated, an error is thrown.
\itemize{
\item \code{NULL}, the default, doesn't expect there to be any relationship between
\code{x} and \code{y}. However, for equality joins it will check for a many-to-many
relationship (which is typically unexpected) and will warn if one occurs,
encouraging you to either take a closer look at your inputs or make this
relationship explicit by specifying \code{"many-to-many"}.

See the \emph{Many-to-many relationships} section for more details.
\item \code{"one-to-one"} expects:
\itemize{
\item Each row in \code{x} matches at most 1 row in \code{y}.
\item Each row in \code{y} matches at most 1 row in \code{x}.
}
\item \code{"one-to-many"} expects:
\itemize{
\item Each row in \code{y} matches at most 1 row in \code{x}.
}
\item \code{"many-to-one"} expects:
\itemize{
\item Each row in \code{x} matches at most 1 row in \code{y}.
}
\item \code{"many-to-many"} doesn't perform any relationship checks, but is provided
to allow you to be explicit about this relationship if you know it
exists.
}

\code{relationship} doesn't handle cases where there are zero matches. For that,
see \code{unmatched}.}
}
\description{
This is a method for the \code{\link[dplyr:mutate-joins]{dplyr::left_join()}} generic.
See "Fallbacks" section for differences in implementation.
A \code{left_join()} keeps all observations in \code{x}.
}
\section{Fallbacks}{

There is no DuckDB translation in \code{left_join.duckplyr_df()}
\itemize{
\item for an implicit cross join,
\item for a value of the \code{multiple} argument that isn't the default \code{"all"}.
\item for a value of the \code{unmatched} argument that isn't the default \code{"drop"}.
}

These features fall back to \code{\link[dplyr:mutate-joins]{dplyr::left_join()}}, see \code{vignette("fallback")} for details.
}

\examples{
library(duckplyr)
left_join(band_members, band_instruments)
}
\seealso{
\code{\link[dplyr:mutate-joins]{dplyr::left_join()}}
}
