% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_adsub_adsl.R
\name{join_adsub_adsl}
\alias{join_adsub_adsl}
\alias{join_adsub_adsl.list}
\title{Join \code{adsub} to \code{adsl}}
\usage{
join_adsub_adsl(
  adam_db,
  keys,
  continuous_var,
  categorical_var,
  continuous_suffix,
  categorical_suffix,
  drop_na = TRUE,
  drop_lvl = TRUE
)

\method{join_adsub_adsl}{list}(
  adam_db,
  keys = c("USUBJID", "STUDYID"),
  continuous_var = "all",
  categorical_var = "all",
  continuous_suffix = "",
  categorical_suffix = "_CAT",
  drop_na = TRUE,
  drop_lvl = FALSE
)
}
\arguments{
\item{adam_db}{(\code{list} of \code{data.frame}) object input with an \code{adsl} and \code{adsub} table.}

\item{keys}{(\code{character}) the name of the columns in \code{adsl} uniquely identifying a row.}

\item{continuous_var}{(\code{character}) the value of a parameter in the \code{PARAMCD} column of the \code{adsub} table from which
columns containing continuous values should be created. If \code{"all"}, all parameter values are selected, if \code{NULL},
none are selected.}

\item{categorical_var}{(\code{character}) the value of a parameter in the \code{PARAMCD} column of the \code{adsub} table from which
columns containing categorical values should be created. If \code{"all"}, all parameter values are selected, if \code{NULL},
none are selected.}

\item{continuous_suffix}{(\code{string}) the suffixes to add to the newly generated columns containing continuous values.}

\item{categorical_suffix}{(\code{string}) the suffixes to add to the newly generated columns containing categorical
values.}

\item{drop_na}{(\code{logical}) whether resulting columns containing only \code{NAs} should be dropped.}

\item{drop_lvl}{(\code{logical}) should missing levels be dropped in the resulting columns.}
}
\value{
a \code{list} of \code{data.frame} with new columns in the \code{adsl} table.
}
\description{
Join \code{adsub} to \code{adsl}
}
\examples{
adsl <- data.frame(
  USUBJID = c("S1", "S2", "S3", "S4"),
  STUDYID = "My_study",
  AGE = c(60, 44, 23, 31)
)

adsub <- data.frame(
  USUBJID = c("S1", "S2", "S3", "S4", "S1", "S2", "S3"),
  STUDYID = "My_study",
  PARAM = c("weight", "weight", "weight", "weight", "height", "height", "height"),
  PARAMCD = c("w", "w", "w", "w", "h", "h", "h"),
  AVAL = c(98, 75, 70, 71, 182, 155, 152),
  AVALC = c(">80", "<=80", "<=80", "<=80", ">180", "<=180", "<=180")
)

db <- list(adsl = adsl, adsub = adsub)

x <- join_adsub_adsl(adam_db = db)
x <- join_adsub_adsl(adam_db = db, continuous_var = c("w", "h"), categorical_var = "h")
}
