% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{which_max_iv}
\alias{which_max_iv}
\title{Return Index of (First) Maximum of an Integer Vector}
\usage{
which_max_iv(x)
}
\arguments{
\item{x}{Integer vector.}
}
\value{
Integer value.
}
\description{
Written in C++, this function tends to run faster than 
\code{\link[base]{which.max}} for large integer vectors.
}
\details{
For optimal speed, choose the version of this function that matches the 
class of your \code{x}:

\code{\link{which_max_nv}} for numeric vector. \cr
\code{\link{which_max_iv}} for integer vector. \cr
\code{\link{which_max_nm}} for numeric matrix. \cr
\code{\link{which_max_im}} for integer matrix.
}
\examples{
# For long vectors, which_max_iv is faster than which.max
x <- rpois(10000, lambda = 15)
which.max(x) == which_max_iv(x)
benchmark(which.max(x), which_max_iv(x), replications = 5000)

# For shorter vectors, which_max_iv is slower than which.max
x <- rpois(100, lambda = 15)
which.max(x) == which_max_iv(x)
benchmark(which.max(x), which_max_iv(x), replications = 20000)

}
