% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{which_min_nv}
\alias{which_min_nv}
\title{Return Index of (First) Minimum of a Numeric Vector}
\usage{
which_min_nv(x)
}
\arguments{
\item{x}{Numeric vector.}
}
\value{
Integer value.
}
\description{
Written in C++, this function tends to run faster than 
\code{\link[base]{which.min}} for large numeric vectors.
}
\details{
For optimal speed, choose the version of this function that matches the 
class of your \code{x}:

\code{\link{which_min_nv}} for numeric vector. \cr
\code{\link{which_min_iv}} for integer vector. \cr
\code{\link{which_min_nm}} for numeric matrix. \cr
\code{\link{which_min_im}} for integer matrix.
}
\examples{
# For long vectors, which_min_nv is faster than which.min
x <- rnorm(100000)
which.min(x) == which_min_nv(x)
benchmark(which.min(x), which_min_nv(x), replications = 1000)

# For shorter vectors, which_min_nv is slower than which.min
x <- rnorm(100)
which.min(x) == which_min_nv(x)
benchmark(which.min(x), which_min_nv(x), replications = 10000)

}
