% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormalreg.R
\name{lognormalreg}
\alias{lognormalreg}
\title{Linear Regression of log(Y) vs. Covariates with Y Potentially Subject to 
Multiplicative Lognormal Errors}
\usage{
lognormalreg(y, x = NULL, merror = FALSE, estimate_var = TRUE,
  fix_posdef = FALSE, ...)
}
\arguments{
\item{y}{Numeric vector or list.}

\item{x}{Numeric vector or matrix. If \code{NULL}, model reduces to marginal
lognormal model Y ~ Lognormal(beta_0, sigsq).}

\item{merror}{Logical value for whether to model multiplicative lognormal 
measurement errors in Y.}

\item{estimate_var}{Logical value for whether to return Hessian-based
variance-covariance matrix.}

\item{fix_posdef}{Logical value for whether to repeatedly reduce
\code{integrate_tol_hessian} by factor of 5 and re-estimate Hessian to try
to avoid non-positive definite variance-covariance matrix.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List containing:
\enumerate{
\item Numeric vector of parameter estimates.
\item Variance-covariance matrix (if \code{estimate_var = TRUE}).
\item Returned \code{\link[stats]{nlminb}} object from maximizing the
log-likelihood function.
\item Akaike information criterion (AIC).
}
}
\description{
Uses maximum likelihood to fit
Y|\strong{X} ~ Lognormal(beta_0 + \strong{beta_x}^T \strong{X}, sigsq). Y 
can be precisely measured or subject to multiplicative mean-1 lognormal 
errors, in which case replicates can be incorporated by specifying \code{y} 
as a list).
}
