% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ll.R
\name{plot_ll}
\alias{plot_ll}
\title{Plot Log-Likelihood vs. Values of One Parameter}
\usage{
plot_ll(start, objective, lower = -Inf, upper = Inf, xaxis_param = 1,
  xaxis_range = NULL, param_values = NULL, mles = NULL,
  return_info = FALSE)
}
\arguments{
\item{start}{See \code{\link[stats]{nlminb}}.}

\item{objective}{See \code{\link[stats]{nlminb}}.}

\item{lower}{See \code{\link[stats]{nlminb}}.}

\item{upper}{See \code{\link[stats]{nlminb}}.}

\item{xaxis_param}{Integer value specifying which parameter should be plotted
on the x-axis.}

\item{xaxis_range}{Numeric vector specifying x-axis range over which to vary 
the parameter of interest. Only values with likelihood ratio > 0.01 are 
ultimately plotted.}

\item{param_values}{Numeric vector of values to use for other parameters in
model, in case you want an additional curve for log-likelihood function vs.
parameter of interest at certain non-MLE values for other parameters. For
example, if there are 3 parameters and \code{xaxis_param = 2}, you could set
\code{param_values = c(0, NA, 0)}.}

\item{mles}{Numeric vector of previously obtained maximum likelihood
estimates.}

\item{return_info}{Logical value for whether to return the estimated MLEs and 
99.99\% confidence intervals for parameters rather than create the plot.}
}
\value{
Plot of log-likelihood vs. value of parameter of interest, generated
by \code{\link[ggplot2]{ggplot}}.
}
\description{
Generates plot of log-likelihood vs. one parameter of interest while other
parameters are held fixed at certain values (e.g. MLEs). This is not a 
profile likelihood, and is mainly intended for use with a Shiny app.
}
\details{
Note that \code{objective} should be the negative log-likelihood function, 
since internal optimization uses (\code{\link[stats]{nlminb}}), which does 
minimization.
}
\examples{
# Generate normal data, define log-likelihood function, and plot likelihood
set.seed(123)
x <- rnorm(100, mean = 0.5, sd = sqrt(0.25))
ll.f <- function(theta) {
  return(-sum(dnorm(x, log = TRUE, mean = theta[1], sd = sqrt(theta[2]))))
}
plot_ll(start = c(0, 1), objective = ll.f, lower = c(-Inf, 1e-6))


}
