% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_check_tax_status.R
\name{dct_check_tax_status}
\alias{dct_check_tax_status}
\title{Check that taxonomicStatus is within valid values in
Darwin Core taxonomic data}
\usage{
dct_check_tax_status(
  tax_dat,
  on_fail = dct_options()$on_fail,
  on_success = dct_options()$on_success,
  valid_tax_status = dct_options()$valid_tax_status,
  quiet = dct_options()$quiet
)
}
\arguments{
\item{tax_dat}{Dataframe; taxonomic database in DwC format.}

\item{on_fail}{Character vector of length 1, either "error" or "summary". Describes what to do if the check fails. Default \code{"error"}.}

\item{on_success}{Character vector of length 1, either "logical" or "data". Describes what to do if the check passes. Default \code{"data"}.}

\item{valid_tax_status}{Character vector of length 1; valid values for \code{taxonomicStatus}. Each value must be separated by a comma. Default \verb{accepted, synonym, variant, NA}. \code{"NA"} indicates that missing (NA) values are valid. Case-sensitive. (see Examples).}

\item{quiet}{Logical vector of length 1; should warnings be silenced? Default \code{FALSE}.}
}
\value{
Depends on the result of the check and on values of \code{on_fail} and
\code{on_success}:
\itemize{
\item If the check passes and \code{on_success} is "logical", return \code{TRUE}
\item If the check passes and \code{on_success} is "data", return the input dataframe
\item If the check fails and \code{on_fail} is "error", return an error
\item If the check fails and \code{on_fail} is "summary", issue a warning and
return a dataframe with a summary of the reasons for failure
}
}
\description{
Check that taxonomicStatus is within valid values in
Darwin Core taxonomic data
}
\examples{
# The bad data has an taxonomicStatus (third row, "foo") that is not
# a valid value
bad_dat <- tibble::tribble(
  ~taxonID, ~acceptedNameUsageID, ~taxonomicStatus, ~scientificName,
  "1", NA, "accepted", "Species foo",
  "2", "1", "synonym", "Species bar",
  "3", NA, "foo", "Species bat"
)

dct_check_tax_status(bad_dat, on_fail = "summary", quiet = TRUE)

# Example of setting valid values of taxonomicStatus via dct_options()

# First store existing settings, including any changes made by the user
old_settings <- dct_options()

# Change options for valid_tax_status
dct_options(valid_tax_status = "provisionally accepted, synonym, NA")
tibble::tribble(
  ~taxonID, ~acceptedNameUsageID, ~taxonomicStatus, ~scientificName,
  "1", NA, "provisionally accepted", "Species foo",
  "2", "1", "synonym", "Species bar",
  "3", NA, NA, "Strange name"
) |>
  dct_check_tax_status()

# Reset options to those before this example was run
do.call(dct_options, old_settings)
}
\references{
\url{https://dwc.tdwg.org/terms/#dwc:taxonomicStatus}
}
