% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{incGamma}
\alias{incGamma}
\title{Incomplete Gamma Function}
\usage{
incGamma(a, x, lower = FALSE)
}
\arguments{
\item{a}{positive numeric vector}

\item{x}{non-negative numeric vector}

\item{lower}{boolean for calculating lower or upper incomplete gamma function}
}
\value{
scalar or vector of length = max(length(x), length(a)), with values
 of the shorter recycled to match the length of the longer a la pnorm etc.
}
\description{
Incomplete Gamma Function
}
\details{
The upper incomplete gamma function, following Wolfram Alpha, namely,
 incGamma(a, x) = \eqn{\int_x^\infty e^{-t} * t^{a - 1}dt}{%
 integral(exp(-t) * t^(a - 1) dt from x to Inf)},
 calculated using pgamma. Within the \code{dwp} package, \code{incGamma} is 
 used in the calculation of the cumulative distribution function (CDF) of the
 xep02 distribution (\code{pxep02}). NOTE: The function \code{pracma::incgam} also
 calculates incomplete gamma with \code{pracma::incgam(x, a) = incGamma(a, x)},
 but \code{pracma::incgam} is not vectorized and not used here.
}
