/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.FontMenuItem;
import jas.plot.MovableObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPopupMenu;

public abstract class TextBlock
extends MovableObject {
    protected FontMetrics fm;
    private int blockwidth;
    private int blockheight;
    private int maxleftsplitwidth;
    private int maxrightsplitwidth;
    private int numberlinesallocated;
    private static final int WIDTHSPACE = 5;
    private static final int LEFTALIGNSPLIT = 1;
    private static final int RIGHTALIGNSPLIT = 2;
    private static final int NOALIGNSPLIT = 3;

    public TextBlock(String prefix) {
        super(prefix);
        this.setBorderType(4);
        this.setFont(new Font("SansSerif", 0, 10));
    }

    public abstract int getNLines();

    public abstract String getLine(int var1);

    public abstract int getSplitStringAlign();

    public Dimension getPreferredSize() {
        if (this.fm == null) {
            this.fm = this.getToolkit().getFontMetrics(this.getFont());
        }
        this.allocateSize();
        Insets i = this.getInsets();
        return new Dimension(this.blockwidth + i.right + i.left, i.top + i.bottom + this.blockheight);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getForeground());
        if (this.fm == null) {
            this.fm = g.getFontMetrics(this.getFont());
        }
        Insets insets = this.getInsets();
        int y = this.fm.getAscent() + insets.top;
        int fmheight = this.fm.getHeight();
        int splitalign = this.getSplitStringAlign();
        boolean callrevalidate = false;
        if (this.getNLines() != this.numberlinesallocated) {
            callrevalidate = true;
        }
        for (int i = 0; i < this.getNLines(); ++i) {
            String line = this.getLine(i);
            if (line == null) continue;
            if (line.equals("\n")) {
                if (i <= 0) continue;
                g.drawLine(insets.left, y -= fmheight / 2, this.blockwidth + insets.right, y);
                y += fmheight;
                continue;
            }
            String[] splitline = this.formatLine(line);
            if (this.fm.stringWidth(splitline[0]) > this.maxleftsplitwidth || splitline[1] != null && this.fm.stringWidth(splitline[1]) > this.maxrightsplitwidth) {
                callrevalidate = true;
            }
            g.drawString(splitline[0], insets.left, y);
            if (splitline[1] != null && splitalign == 1) {
                g.drawString(splitline[1], insets.left + this.maxleftsplitwidth, y);
            } else if (splitline[1] != null && splitalign == 2) {
                g.drawString(splitline[1], insets.left + this.rightAlignSplitWidth(splitline[1]), y);
            } else if (splitline[1] != null && splitalign == 3) {
                g.drawString(splitline[1], insets.left + this.fm.stringWidth(splitline[0]), y);
            }
            y += fmheight;
        }
        if (callrevalidate) {
            this.revalidate();
        }
    }

    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        menu.add(new FontMenuItem(this, this.getPrefix()));
        super.modifyPopupMenu(menu, source);
    }

    private String[] formatLine(String s) {
        String[] splitline = new String[2];
        if (s != null) {
            int index = s.indexOf(9);
            if (index >= 0) {
                splitline[0] = "  " + s.substring(0, index) + " : ";
                splitline[1] = s.substring(index + 1) + " ";
            } else {
                splitline[0] = s;
            }
        }
        return splitline;
    }

    protected void allocateSize() {
        this.maxleftsplitwidth = 0;
        this.maxrightsplitwidth = 0;
        this.blockwidth = 30;
        this.blockheight = 0;
        int fmheight = this.fm.getHeight();
        this.numberlinesallocated = this.getNLines();
        for (int i = 0; i < this.getNLines(); ++i) {
            String s = this.getLine(i);
            if (s == null) continue;
            if (s.equals("\n")) {
                if (i <= 0) continue;
                this.blockheight += fmheight / 2;
                continue;
            }
            this.blockheight += fmheight;
            this.blockWidth(s);
        }
        if (this.blockheight == 0) {
            this.blockheight = fmheight;
        }
    }

    private int rightAlignSplitWidth(String s) {
        int width = 0;
        int rightwidth = 0;
        if (s != null) {
            rightwidth = this.fm.stringWidth(s);
            width = this.blockwidth - rightwidth - 5;
        }
        return width;
    }

    private void blockWidth(String s) {
        String[] splitline = this.formatLine(s);
        int width = 0;
        int leftwidth = 0;
        int rightwidth = 0;
        int splitalign = this.getSplitStringAlign();
        if (splitline[0] != null) {
            leftwidth = this.fm.stringWidth(splitline[0]);
        }
        if (splitline[1] != null) {
            rightwidth = this.fm.stringWidth(splitline[1]);
        }
        if (splitalign == 1 && splitline[1] != null) {
            if (leftwidth > this.maxleftsplitwidth) {
                this.maxleftsplitwidth = leftwidth;
            }
            if (rightwidth > this.maxrightsplitwidth) {
                this.maxrightsplitwidth = rightwidth;
            }
            width = this.maxrightsplitwidth + this.maxleftsplitwidth + 5;
        } else {
            width = rightwidth + leftwidth + 5;
        }
        if (width > this.blockwidth) {
            this.blockwidth = width;
        }
    }

    public void setFont(Font p1) {
        super.setFont(p1);
        this.fm = null;
        this.revalidate();
        this.repaint();
    }
}

