/*
 * Decompiled with CFR 0.152.
 */
package don;

import don.DonneeID;
import don.DonneeMoyenne;
import don.Groupe;
import don.Individu;
import exceptions.ExceptionIntegrite;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndividuMoyen
extends Individu
implements DonneeMoyenne {
    private static final long serialVersionUID = 6648446927310047453L;
    private Vector<Individu> m_branches = new Vector();

    public IndividuMoyen(String annotation, boolean active, Groupe gr, double[] coord, double[] cos2, double[] contrib, double[] z) {
        super(annotation, active, gr, coord, cos2, contrib, z);
    }

    @Override
    public Vector<DonneeID> getBranches() {
        return new Vector<DonneeID>(this.m_branches);
    }

    public Individu get(int i) {
        return this.m_branches.get(i);
    }

    public void addBranche(Individu fille) {
        this.m_branches.add(fille);
        if (fille.getPere() == null || !fille.getPere().equals(this)) {
            fille.setPere(this);
        }
    }

    @Override
    public int getNbBranches() {
        return this.m_branches.size();
    }

    @Override
    public void setGeneration(int generation) {
        super.setGeneration(generation);
        for (Individu mod_fille : this.m_branches) {
            mod_fille.setGeneration(generation + 1);
        }
    }

    public Individu getIndividu(String annot) {
        Individu trouve = null;
        if (this.getAnnotation().equals(annot)) {
            trouve = this;
        } else {
            int i = 0;
            while (i < this.getNbBranches() && trouve == null) {
                Individu temp = this.m_branches.elementAt(i);
                if (temp instanceof IndividuMoyen) {
                    trouve = ((IndividuMoyen)temp).getIndividu(annot);
                } else if (temp.getAnnotation().equals(annot)) {
                    trouve = temp;
                }
                ++i;
            }
        }
        return trouve;
    }

    @Override
    public String toString() {
        String chaine = super.toString();
        for (Individu fille : this.m_branches) {
            chaine = String.valueOf(chaine) + "\nenfant : " + fille.toString();
        }
        chaine = String.valueOf(chaine) + "\n(fin " + this.getAnnotation() + ")\n";
        return chaine;
    }

    @Override
    public void verifierIntegrite() throws ExceptionIntegrite {
        super.verifierIntegrite();
        for (Individu ind : this.m_branches) {
            ind.verifierIntegrite();
        }
    }

    public static void main(String[] args) {
        Individu fils = new Individu("ind1", true, null, null, null, null, null);
        IndividuMoyen pere = new IndividuMoyen("ind2", true, null, null, null, null, null);
        Individu fils2 = new Individu("ind3", true, null, null, null, null, null);
        fils.setPere(pere);
        pere.addBranche(fils2);
        System.out.println("Apr\ufffds construction de l'arborescence :");
        System.out.println(pere);
        pere.setGeneration(3);
        System.out.println("---------------------------\nApr\ufffds avoir fix\ufffd le niveau du p\ufffdre \ufffd 3 :");
        System.out.println(pere);
        System.out.println("---------------------------\nindividu d'annotation \"ind3\" :\n" + pere.getIndividu("ind3"));
    }
}

