/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import org.freehep.graphics2d.TagString;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestText2D
extends TestingPanel {
    public TestText2D(String[] args) throws Exception {
        super(args);
        this.setName("Tag Strings");
    }

    public void paintComponent(Graphics g) {
        if (g != null) {
            VectorGraphics vg = VectorGraphics.create((Graphics)g);
            Dimension dim = this.getSize();
            Insets insets = this.getInsets();
            vg.setColor(Color.white);
            vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
            int dw = dim.width / 3;
            int dh = dim.height / 10;
            vg.setColor(Color.green);
            for (int y = 0; y < 8; ++y) {
                int iy = (int)(((double)y + 0.5) * (double)dh);
                vg.drawLine(0, iy, dim.width, iy);
            }
            for (int x = 0; x < 3; ++x) {
                int ix = (int)(((double)x + 0.5) * (double)dw);
                vg.drawLine(ix, 0, ix, dim.height);
            }
            String saying = "&lt;Vector<sup><b>\\Graphics%</b></sup> &amp; Card<i><sub>)Adapter)</sub></i>&gt;";
            TagString text = new TagString(saying);
            vg.setColor(Color.red);
            vg.setFont(new Font("SansSerif", 0, 10));
            for (int y = 0; y < 8; ++y) {
                int iy = (int)(((double)y + 0.5) * (double)dh);
                for (int x = 0; x < 3; ++x) {
                    int ix = (int)(((double)x + 0.5) * (double)dw);
                    if (y == 4) {
                        vg.drawString(text, (double)ix, (double)iy, 3 - x, y % 4, true, Color.cyan, 2.0, true, Color.black);
                        continue;
                    }
                    if (y == 5) {
                        vg.drawString(text, (double)ix, (double)iy, 3 - x, y % 4, false, Color.cyan, 2.0, true, Color.black);
                        continue;
                    }
                    if (y == 6) {
                        vg.drawString(text, (double)ix, (double)iy, 3 - x, y % 4, true, Color.cyan, 2.0, false, Color.black);
                        continue;
                    }
                    if (y == 7) {
                        vg.drawString(text, (double)ix, (double)iy, 3 - x, y % 4, false, Color.cyan, 2.0, false, Color.black);
                        continue;
                    }
                    vg.drawString(text, (double)ix, (double)iy, 3 - x, y % 4);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        new TestText2D(args).runTest();
    }
}

