% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamic_proj_GIF.R
\name{dynamic_proj_GIF}
\alias{dynamic_proj_GIF}
\title{Create GIF of dynamic species distribution and abundance projections}
\usage{
dynamic_proj_GIF(
  dates,
  projection.type,
  drive.folder,
  user.email,
  local.directory,
  save.drive.folder,
  save.directory,
  width = 10,
  height = 10,
  legend.max,
  legend.min,
  legend.name,
  file.name,
  borders = FALSE,
  border.regions,
  border.colour = "black",
  colour.palette.custom,
  colour.palette
)
}
\arguments{
\item{dates}{a character vector , projection dates in format "YYYY-MM-DD".}

\item{projection.type}{a character string, the type of distribution or abundance projection to
plot. One of \code{proportional}, \code{binary}, \code{abundance} and \code{stacked}.}

\item{drive.folder}{optional; a character string, the Google Drive folder to read projection
rasters from. Folder must be uniquely named within Google Drive. Do not provide path.}

\item{user.email}{optional; a character string, user email for initialising Google Drive. Required
if \code{drive.folder} or \code{save.drive.folder} used.}

\item{local.directory}{optional; a character string, the path to local directory to read
projection rasters from.}

\item{save.drive.folder}{optional; a character string, Google Drive folder to save GIF to. Folder
must be uniquely named within Google Drive. Do not provide path.}

\item{save.directory}{optional; a character string, path to local directory to save GIF to.}

\item{width}{optional; a numeric value, the GIF width in inches Default = 480.}

\item{height}{optional; a numeric value, the GIF height in inches Default = 480.}

\item{legend.max}{optional; a numeric value, the maximum limit of legend values to standardise
across projections.}

\item{legend.min}{optional; a numeric value, the minimum limit of legend values to standardise
across projections.}

\item{legend.name}{optional; a character string, the name for the legend title. Default =
projection.type.}

\item{file.name}{optional, a character string, the name for the output GIF file. Default =
\code{projection.type}.}

\item{borders}{a logical indicating whether to add country borders to map. Default = \code{FALSE}.}

\item{border.regions}{optional; a character string or vector, the region or regionss for which to
add map borders. Required if \code{borders = TRUE}.}

\item{border.colour}{optional; a character vector, the colour for plotted map borders. Default =
\code{black.}}

\item{colour.palette.custom}{optional; a character string or vector, the colours to use as plot
colour palette.}

\item{colour.palette}{optional; a character string, the colormap option to use from \code{viridis}. See
details for colour palette options.}
}
\value{
Exports GIF to Google Drive folder or local directory.
}
\description{
Plots dynamic species distribution and abundance projections through time and combines images into
a GIF.
}
\details{
Function reads in projection rasters for each date. These are plotted using \code{ggplot2} and
combined into a Graphics Interchange Format (GIF).
}
\section{Import projection rasters}{
Projection rasters for each date must be “tif” files that are uniquely named with the date
in format "YYYY-MM-DD" and \code{projection.type.} If more than one file name matches the date and
\code{projection.type}, the function will error.
}

\section{Google Drive compatibility}{
If \code{drive.folder} or \code{save.drive.folder} is given, please ensure the folder name is unique
within your Google Drive. Do not provide the path if the folder is nested within others.

If one of \code{drive.folder} or \code{save.drive.folder} are used then \code{user.email} is required to access
the appropriate Google Drive user account. This requires users to have installed R package
\code{googledrive} and initialised Google Drive with valid log-in credentials. Please follow
instructions on \url{https://googledrive.tidyverse.org/}.

Options for colour palettes using \code{viridis} are illustrated at:
\url{https://ggplot2.tidyverse.org/reference/scale_viridis.html}. Available options include: "magma"
(or "A"), "inferno" (or "B"), "plasma" (or "C"), "viridis" (or "D", the default option),
"cividis" (or "E"), "rocket" (or "F"), "mako"(or "G") and "turbo" (or "H").
}

\examples{
projectiondates <- dynamic_proj_dates(startdate = "2018-01-01",
                                     enddate = "2018-12-01",
                                     interval = 3,
                                     interval.level = "month")
\donttest{
data(sample_proj_rast)
# Save sample projection rasters to replicate output from `dynamic_proj()`

raster::writeRaster(sample_proj_rast[[1]],
 filename = paste0(tempdir(), "/", paste0(projectiondates[1], "_proportional.tif")),
 overwrite = TRUE)
raster::writeRaster(sample_proj_rast[[2]],
 filename = paste0(tempdir(), "/", paste0(projectiondates[2], "_proportional.tif")),
 overwrite = TRUE)
raster::writeRaster(sample_proj_rast[[3]],
 filename = paste0(tempdir(), "/", paste0(projectiondates[3], "_proportional.tif")),
 overwrite = TRUE)
raster::writeRaster(sample_proj_rast[[4]],
 filename = paste0(tempdir(), "/", paste0(projectiondates[4], "_proportional.tif")),
 overwrite = TRUE)

dynamic_proj_GIF(
dates = projectiondates,
projection.type = "proportional",
local.directory = tempdir(),
save.directory = tempdir()
)
}
}
\references{
Wickham, H., and Chang, W, 2016. Package ‘ggplot2’. Create elegant data
visualisations using the grammar of graphics. Version, 2(1), pp.1-189.
}
