% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_est.R
\name{ddhazard_boot}
\alias{ddhazard_boot}
\title{Bootstrap for \code{\link{ddhazard}}}
\usage{
ddhazard_boot(ddhazard_fit, strata, unique_id, R = 100,
  do_stratify_with_event = T, do_sample_weights = F, print_errors = F)
}
\arguments{
\item{ddhazard_fit}{Returned object from a \code{\link{ddhazard}} call}

\item{strata}{Strata to sample within. These need to be on an individual by individual basis and not rows in the design matrix}

\item{unique_id}{Unique ids where entries match entries of \code{strata}}

\item{R}{Number of bootstrap estimates}

\item{do_stratify_with_event}{\code{TRUE} if sampling should be by strata of whether the individual has an event. An interaction factor will be made if \code{strata} is provided}

\item{do_sample_weights}{\code{TRUE} if weights should be sample instead of individuals}

\item{print_errors}{\code{TRUE} if errors should be printed when estimations fails}
}
\value{
An object like returned from the \code{\link[boot]{boot}} function
}
\description{
See the vignette 'Bootstrap illustration'
}
\seealso{
\code{\link{ddhazard}}, \code{\link[=plot.fahrmeier_94]{plot}}
}

