% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_linearised_comparison.R
\name{plot_linearised_comparison}
\alias{plot_linearised_comparison}
\title{Compare two trajectories as a pseudotime scatterplot}
\usage{
plot_linearised_comparison(
  traj1,
  traj2,
  reorder = TRUE,
  margin = 0.05,
  reorder_second_by = c("mapping", "optimisation")
)
}
\arguments{
\item{traj1}{The first trajectory}

\item{traj2}{The second trajectory}

\item{reorder}{Whether to reorder the trajectory}

\item{margin}{A margin between trajectory segments.}

\item{reorder_second_by}{How to reorder the second trajectory, either by mapping the milestones from both trajectories (\code{mapping}), or by trying to correlate the orderings between the two trajectories (\code{optimisation})}
}
\value{
A scatterplot comparison ggplot of two linearised trajectories.
}
\description{
Compare two trajectories as a pseudotime scatterplot
}
\examples{
data(example_bifurcating)
plot_linearised_comparison(example_bifurcating, example_bifurcating)
}
\keyword{compare_trajectory}
