% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dimred.R
\name{plot_dimred}
\alias{plot_dimred}
\title{Plot a trajectory in a (given) dimensionality reduction}
\usage{
plot_dimred(
  trajectory,
  color_cells = c("auto", "none", "grouping", "feature", "milestone", "pseudotime"),
  dimred = ifelse(dynwrap::is_wrapper_with_dimred(trajectory), NA,
    dyndimred::dimred_landmark_mds),
  plot_trajectory = dynwrap::is_wrapper_with_trajectory(trajectory) &&
    !plot_milestone_network,
  plot_milestone_network = FALSE,
  label_milestones = dynwrap::is_wrapper_with_milestone_labelling(trajectory),
  alpha_cells = 1,
  size_cells = 2.5,
  border_radius_percentage = 0.1,
  size_milestones = 6,
  size_transitions = 2,
  hex_cells = ifelse(length(trajectory$cell_ids) > 10000, 100, FALSE),
  grouping = NULL,
  groups = NULL,
  feature_oi = NULL,
  color_milestones = c("auto", "given", "cubeHelix", "Set3", "rainbow"),
  milestones = NULL,
  milestone_percentages = NULL,
  pseudotime = NULL,
  expression_source = "expression",
  arrow = grid::arrow(type = "closed", length = unit(0.1, "inches")),
  color_density = c("none", "grouping", "feature"),
  padding = 0.1,
  nbins = 1000,
  bw = 0.2,
  density_cutoff = 0.3,
  density_cutoff_label = density_cutoff/10,
  waypoints = dynwrap::select_waypoints(trajectory),
  trajectory_projection_sd = sum(trajectory$milestone_network$length) * 0.05,
  color_trajectory = "none"
)
}
\arguments{
\item{trajectory}{A dynwrap trajectory.}

\item{color_cells}{How to color the cells.
\itemize{
\item \code{"auto"}: Try to figure out how to color cells depending on whether
one of the \code{grouping}, \code{feature_io}, \code{milestones} or \code{pseudotime} parameters are defined.
\item \code{"none"}: Cells are not coloured.
\item \code{"grouping"}: Cells are coloured according to a grouping (e.g. clustering).
Either the \code{grouping} parameter or \code{trajectory$grouping} must be a named character vector.
\item \code{"feature"}: Cells are coloured according to the values of a given feature (e.g. gene expression).
Either the \code{expression_source} parameter or \code{get_expression(trajectory)} must be a matrix.
Parameter \code{feature_oi} must also be defined.
\item \code{"milestone"} (recommended): Cells are coloured according their position in the trajectory. The positioning of the
cells are determined by parameter \code{milestone_percentages} or else by \code{trajectory$milestone_percentages}. The colours
of the milestones can be determined automatically or can be specified by passing a tibble containing character columns
\code{milestone_id} and \code{color} (See \code{add_milestone_coloring()} for help in constructing this object).
\item \code{"pseudotime"}: Cells are coloured according to the pseudotime value from the root.
}}

\item{dimred}{Can be
\itemize{
\item A function which will perform the dimensionality reduction, see \code{\link[dyndimred:dimred]{dyndimred::list_dimred_methods()}}
\item A matrix with the dimensionality reduction, with cells in rows and dimensions (\emph{comp_1}, \emph{comp_2}, ...) in columns
}}

\item{plot_trajectory}{Whether to plot the projected trajectory on the dimensionality reduction}

\item{plot_milestone_network}{Whether to plot the projected milestone network on the dimensionality reduction}

\item{label_milestones}{How to label the milestones. Can be TRUE (in which case the labels within the trajectory will be used), "all" (in which case both given labels and milestone_ids will be used), a named character vector, or FALSE}

\item{alpha_cells}{The alpha of the cells}

\item{size_cells}{The size of the cells}

\item{border_radius_percentage}{The fraction of the radius that is used for the border}

\item{size_milestones}{The size of the milestones}

\item{size_transitions}{The size of the trajectory segments}

\item{hex_cells}{The number of hexes to use, to avoid overplotting points. Default is FALSE if number of cells <= 10000.}

\item{grouping}{A grouping of the cells (e.g. clustering) as a named character vector.}

\item{groups}{A tibble containing character columns \code{group_id} and \code{color}. If \code{NULL}, this object is inferred from the \code{grouping} itself.}

\item{feature_oi}{The name of a feature to use for colouring the cells.}

\item{color_milestones}{Which palette to use for colouring the milestones
\itemize{
\item \code{auto}: Determine colours automatically. If \code{color} is already specified in
milestones tibble, this will be used. Otherwise, the colour scheme is determined by
\code{milestone_palette_list$auto}.
\item \code{given}: The \code{milestones} object already contains a column \code{color}.
\item \code{cubeHelix}: Use the \code{rje::cubeHelix()} palette.
\item \code{Set3}: Use the \code{RColorBrewer::brewer.pal(name = "Set3")} palette.
\item \code{rainbow}: Use the \code{grDevices::rainbow()} palette.
}}

\item{milestones}{Tibble containing the column \code{milestone_id} (character).
If \code{color_milestones} is set to \code{"given"}, this tibble should also contain a column
\code{color} (character), containing colour hex codes (e.g. \code{"#123456"}).}

\item{milestone_percentages}{The milestone percentages.}

\item{pseudotime}{The pseudotime from the root of the trajectory to the cells as a named numeric vector.}

\item{expression_source}{Source of the expression}

\item{arrow}{The type and size of arrow in case of directed trajectories. Set to NULL to remove arrow altogether.}

\item{color_density}{How to color density, can be "none", "grouping", or "feature".}

\item{padding}{The padding in the edges to the plot, relative to the size of the plot.}

\item{nbins}{Number of bins for calculating the density.}

\item{bw}{Bandwidth, relative to the size of the plot.}

\item{density_cutoff}{Cutoff for density, the lower the larger the areas.}

\item{density_cutoff_label}{Cutoff for density for labeling, the lower the further way from cells.}

\item{waypoints}{The waypoints to use for projecting. Can by generated using \code{\link[dynwrap:add_waypoints]{dynwrap::select_waypoints()}}.}

\item{trajectory_projection_sd}{The standard deviation of the Gaussian kernel to be used for projecting the trajectory.
This is in the order of magnitude as the lengths of the milestone_network.
The lower, the more closely the trajectory will follow the cells.}

\item{color_trajectory}{How to color the trajectory, can be "nearest" for coloring to nearest cell, or "none".}
}
\value{
A dimensionality reduction ggplot of the data.
}
\description{
Plot a trajectory in a (given) dimensionality reduction
}
\examples{
data(example_bifurcating)
plot_dimred(example_bifurcating)

\donttest{
# plotting with umap
if (requireNamespace("uwot", quietly = TRUE)) {
  plot_dimred(example_bifurcating, dimred = dyndimred::dimred_umap)
}

# using a custom dimred
dimred <- dyndimred::dimred_mds(example_bifurcating$expression)
plot_dimred(example_bifurcating, dimred = dimred)

# coloring cells by pseudotime
plot_dimred(example_bifurcating, color_cells = "pseudotime")

# coloring cells by cluster
plot_dimred(
  example_bifurcating,
  color_density = "grouping",
  grouping = dynwrap::group_onto_nearest_milestones(example_bifurcating)
)
}

}
\keyword{plot_trajectory}
