% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_waypoints.R
\name{add_waypoints}
\alias{add_waypoints}
\alias{is_wrapper_with_waypoints}
\alias{select_waypoints}
\title{Add or create waypoints to a trajectory}
\usage{
add_waypoints(
  trajectory,
  n_waypoints = 100,
  resolution = sum(trajectory$milestone_network$length)/n_waypoints
)

is_wrapper_with_waypoints(trajectory)

select_waypoints(
  trajectory,
  n_waypoints = 100,
  resolution = sum(trajectory$milestone_network$length)/n_waypoints
)
}
\arguments{
\item{trajectory}{The trajectory as created by \code{\link[=infer_trajectory]{infer_trajectory()}} or \code{\link[=add_trajectory]{add_trajectory()}}}

\item{n_waypoints}{The number of waypoints}

\item{resolution}{The resolution of the waypoints, measured in the same units as the lengths of the milestone network edges, will be automatically computed using n_waypoints}
}
\value{
\strong{\code{add_waypoints}} returns the trajectory with \emph{waypoints} added, which is a list containing:
\itemize{
\item \emph{milestone_percentages} and \emph{progressions}: The milestone percentages and progressions of each waypoint, in the same format as the cell equivalents (see \code{\link[=add_trajectory]{add_trajectory()}}) but with a \emph{waypoint_id} column instead of a \emph{cell_id} column
\item \emph{geodesic_distances}: a matrix with the geodesic distance of each waypoint (rows) to every cell (columns)
\item \emph{waypoint_network}: a dataframe containing the network between consecutive waypoints, it contains information on the connected waypoints (\emph{from} and \emph{to}) and the edge on which they reside (\emph{from_milestone_id} and \emph{to_milestone_id})
\item \emph{waypoints}: the waypoint identifiers
}

**\code{select_waypoints} returns the list as mentioned in \code{add_waypoints}
}
\description{
Waypoints are points along the trajectory, which do not necessarily correspond to cells. They are selected in such a way that all parts of the trajectory are covered
}
\keyword{adapt_trajectory}
