% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_export.R
\name{import_dataset}
\alias{import_dataset}
\title{Import data into 'R'}
\usage{
import_dataset(file, format = "excel", ...)
}
\arguments{
\item{file}{Character constant. Path to file.}

\item{format}{Character constant. "excel" (default, for .xls or.xlsx files),
csv", or "tsv".}

\item{...}{Parameters to pass to \code{\link[readxl]{read_excel}},
\code{\link[readr]{read_csv}} or \code{\link[readr]{read_tsv}}}
}
\value{
data as a \code{tibble}
}
\description{
Imports a rectangular single table into \R from a .xls, .xlsx, .csv, or .tsv file.
}
\details{
First row is interpreted as column headers by default. For more details see
\code{\link[readxl]{read_excel}} (.xlsx/.xls), \code{\link[readr]{read_csv}} (.csv), or
\code{\link[readr]{read_tsv}} (.tsv).
}
\examples{
\dontrun{
   # This code will not run as it requires an xlsx file
   # ./dataset.xlsx should be replaced with path to user's dataset
   
   # excel
   import_dataset(file = "./dataset.xlsx", format = "excel")
   #csv
   import_dataset(file = "./dataset.csv", format = "csv")
   #tsv
   import_dataset(file = "./dataset.tsv", format = "tsv")
}

}
\seealso{
\code{\link[readxl]{read_excel}} for additional parameters for
  importing .xls or .xlsx files, \code{\link[readr]{read_csv}} for .csv
  files, \code{\link[readr]{read_tsv}} for .tsv files

Other import to/export from 'R' functions: 
\code{\link{export_dataset}()}
}
\concept{import to/export from 'R' functions}
