% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_completeness.R
\name{variable_completeness}
\alias{variable_completeness}
\title{Calculate Variable Completeness in a Data Frame}
\usage{
variable_completeness(data)
}
\arguments{
\item{data}{Data frame.}
}
\value{
\code{Tibble} detailing completeness statistics for each variable.
}
\description{
Calculates the completeness of each variable in a data frame.
}
\details{
This is achieved by comparing the number of \code{NA} to non-\code{NA}
values. Returns the count of \code{NA} as well as the percentage of \code{NA}
values and the percentage completeness.
}
\examples{
data(example_data)
variable_completeness(example_data)
}
\seealso{
Other measures of completeness: 
\code{\link{assess_completeness}()},
\code{\link{compare_completeness}()},
\code{\link{completeness_heatmap}()},
\code{\link{plot_completeness}()},
\code{\link{row_completeness}()}
}
\concept{measures of completeness}
