% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eLNNpaired.r
\name{draw_density}
\alias{draw_density}
\title{Draw probability density of three clusters.}
\usage{
draw_density(psi, t_pi = c(0.3333, 0.3333), x = seq(from = -6, to =
  6, by = 0.1), c1 = qnorm(0.95), c2 = qnorm(0.05), weighted = 1,
  draw_hist = 0, E_Set = NULL)
}
\arguments{
\item{psi}{A vector of length 10. It contains the parameters after reparameterization as illustrated in paper. It has no default value and has to be provided by user.}

\item{t_pi}{the cluster proportion for cluster 1 (over-expressed probes)
and cluster 2 (under-expressed probes).}

\item{x}{A range on which the graph will be drawn. Default value is x = seq(from = -6, to = 6, by = 0.1).}

\item{c1}{A parameter in constraints. It should be in the form of c1 = qnorm(X), where X is a decimal smaller than 1 but close to 1. Larger X gives more stringent constraint. Default value is c1 = qnorm(0.95).}

\item{c2}{A parameter in constraints. It should be in the form of c2 = qnorm(Y), where Y is a decimal larger than 0 but close to 0. Smaller Y gives more stringent constraint. Default value is c2 = qnorm(0.05).}

\item{weighted}{An indicator variable telling if draw weighted densities: zero value for drawing unweighted densities, non-zero value for drawing weighted densities. The weights are provided by t_pi. Default value is weighted = 1.}

\item{draw_hist}{An indicator variable telling if draw histogram from E_Set: zero value for not drawing histogram, non-zero value for drawing histogram. Default value is draw_hist = 0.}

\item{E_Set}{An ExpressionSet based on which a histgram will be drawn. It will only be used when draw_hist is non-zero. Default value is E_Set = NULL.}
}
\value{
No return value.
}
\description{
Draw probability density of three clusters.
}
\examples{
G = 500
n = 10

delta_1 = -0.8184384  
xi_1 = -1.1858546 
lambda_1 = -10.6309216  
nu_1 = -3.5536255  

delta_2 = -0.8153614  
xi_2 = -1.4120148 
lambda_2 = -13.1999427  
nu_2 = -3.3873531   

lambda_3 = 0.7597441  
nu_3 = -2.0361091 

psi = c(delta_1, xi_1, lambda_1, nu_1,
        delta_2, xi_2, lambda_2, nu_2,
        lambda_3, nu_3)
t_pi = c(0.08592752, 0.07110449)

c1 = qnorm(0.95)
c2 = qnorm(0.05)


x = seq(from = -10, to = 10, by = 0.1)
draw_density(psi = psi, 
	t_pi = t_pi, 
	x = x, 
	c1 = c1, 
	c2 = c2,
	weighted = 1,
	draw_hist = 0,
	E_Set = NULL)
}
\references{Li Y, Morrow J, Raby B, Tantisira K, Weiss ST, Huang W, Qiu W. (2017), <doi:10.1371/journal.pone.0174602>}
