% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiencyCEAT.R
\name{efficiencyCEAT}
\alias{efficiencyCEAT}
\title{Convex Efficiency Analysis Tree Efficiency Scores}
\usage{
efficiencyCEAT(
  data,
  x,
  y,
  object,
  scores_model,
  digits = 3,
  DEA = TRUE,
  na.rm = TRUE
)
}
\arguments{
\item{data}{Dataframe containing the DMU for which the efficiency score is calculated.}

\item{x}{Vector. Column input indexes in data.}

\item{y}{Vector. Column output indexes in data.}

\item{object}{An EAT object.}

\item{scores_model}{Mathematical programming model to calculate scores. 
\itemize{
\item{\code{BCC.OUT}} BCC model. Output-oriented.
\item{\code{BCC.INP}}  BCC model. Input-oriented.
\item{\code{DDF}}     Directional Distance Function.
\item{\code{RSL.OUT}} Russell model. Output-oriented.
\item{\code{RSL.INP}}  Russell model. Input-oriented.
\item{\code{WAM.MIP}} Weighted Additive Model. Measure of Inefficiency Proportions.
\item{\code{WAM.RAM}} Weighted Additive Model. Range Adjusted Measure of Inefficiency.
}}

\item{digits}{Integer. Decimal units for scores.}

\item{DEA}{Logical. If \code{TRUE}, DEA scores are calculated with the programming model selected in \code{scores_model}}

\item{na.rm}{Logical. If \code{TRUE}, \code{NA} rows are omitted.}
}
\value{
Dataframe with input variables and efficiency scores through a convex EAT model.
}
\description{
This function calculates the efficiency scores for each DMU through a convex Efficiency Analysis Trees model.
}
\examples{

\donttest{
simulated <- X2Y2.sim(N = 50, border = 0.2)
EAT_model <- EAT(data = simulated, x = c(1,2), y = c(3, 4))

efficiencyCEAT(data = simulated, x = c(1, 2), y = c(3, 4), object = EAT_model, 
              scores_model = "BCC.OUT", digits = 2, DEA = TRUE, na.rm = TRUE)
}

}
