% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composeVar.R
\name{composeVar}
\alias{composeVar}
\title{Create a composite variable.}
\usage{
composeVar(GADSdat, sourceVars, primarySourceVar, newVar)
}
\arguments{
\item{GADSdat}{\code{GADSdat} or \code{all_GADSdat} object imported via eatGADS.}

\item{sourceVars}{Character vector of length two containing the variable names which represent the sources of information.}

\item{primarySourceVar}{Character vector containing a single variable name. Which of the \code{sourceVars} should be preferred?}

\item{newVar}{Character vector containing the name of the new composite variable.}
}
\value{
The modified \code{GADSdat}.
}
\description{
Create a composite variable out of two variables.
}
\details{
A common use case for creating a composite variable is if there are multiple sources for the same information.
For example, a child and the parents are asked about the child's native language. In such cases a composite variable
contains information from both variables, meaning that one source is preferred and the other source is used
to substitute missing values.
}
\examples{
# example data
dat <- data.frame(ID = 1:4,
nat_lang_child = c("Engl", "Ger", "missing", "missing"),
nat_lang_father = c("Engl", "Engl", "Ger", "missing"),
stringsAsFactors = TRUE)
gads <- import_DF(dat)
changeMissings(gads, "nat_lang_child", value = 3, missings = "miss")
changeMissings(gads, "nat_lang_father", value = 3, missings = "miss")

# compose variable
composeVar(gads, sourceVars = c("nat_lang_child", "nat_lang_father"),
           primarySourceVar = "nat_lang_child", newVar = "nat_lang_comp")


}
