% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_fns.R
\name{ebnm_flat}
\alias{ebnm_flat}
\title{Solve the EBNM problem using a flat prior}
\usage{
ebnm_flat(
  x,
  s = 1,
  g_init = NULL,
  fix_g = FALSE,
  output = ebnm_output_default()
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A vector of standard errors (or a scalar if all are equal).
Standard errors may not be exactly zero, and missing standard errors are
not allowed.}

\item{g_init}{Not used by \code{ebnm_flat}, but included for consistency
with other \code{ebnm} functions.}

\item{fix_g}{Not used by \code{ebnm_flat}, but included for consistency
with other \code{ebnm} functions.}

\item{output}{A character vector indicating which values are to be returned.
Function \code{ebnm_output_default()} provides the default return values, while
\code{ebnm_output_all()} lists all possible return values. See \strong{Value}
below.}
}
\value{
An \code{ebnm} object. Depending on the argument to \code{output}, the
  object is a list containing elements:
    \describe{
      \item{\code{data}}{A data frame containing the observations \code{x}
        and standard errors \code{s}.}
      \item{\code{posterior}}{A data frame of summary results (posterior
        means, standard deviations, second moments, and local false sign
        rates).}
      \item{\code{fitted_g}}{The fitted prior \eqn{\hat{g}}.}
      \item{\code{log_likelihood}}{The optimal log likelihood attained,
        \eqn{L(\hat{g})}.}
      \item{\code{posterior_sampler}}{A function that can be used to
        produce samples from the posterior. The sampler takes a single
        parameter \code{nsamp}, the number of posterior samples to return per
        observation.}
     }
   S3 methods \code{coef}, \code{confint}, \code{fitted}, \code{logLik},
   \code{nobs}, \code{plot}, \code{predict}, \code{print}, \code{quantile},
   \code{residuals}, \code{simulate}, \code{summary}, and \code{vcov}
   have been implemented for \code{ebnm} objects. For details, see the
   respective help pages, linked below under \strong{See Also}.
}
\description{
Solves the empirical Bayes normal means (EBNM) problem using a
  "non-informative" improper uniform prior, which yields posteriors
  \deqn{\theta_j | x_j, s_j \sim N(x_j, s_j^2).} Identical to function
  \code{\link{ebnm}} with argument \code{prior_family = "flat"}. For details
  about the model, see \code{\link{ebnm}}.
}
\seealso{
See \code{\link{ebnm}} for examples of usage and model details.

  Available S3 methods include \code{\link{coef.ebnm}},
  \code{\link{confint.ebnm}},
  \code{\link{fitted.ebnm}}, \code{\link{logLik.ebnm}},
  \code{\link{nobs.ebnm}}, \code{\link{plot.ebnm}},
  \code{\link{predict.ebnm}}, \code{\link{print.ebnm}},
  \code{\link{print.summary.ebnm}}, \code{\link{quantile.ebnm}},
  \code{\link{residuals.ebnm}}, \code{\link{simulate.ebnm}},
  \code{\link{summary.ebnm}}, and \code{\link{vcov.ebnm}}.
}
