% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_attribute.R
\name{ebv_attribute}
\alias{ebv_attribute}
\title{Write a new attribute value to an EBV netCDF}
\usage{
ebv_attribute(
  filepath,
  attribute_name,
  value,
  levelpath = NULL,
  verbose = TRUE
)
}
\arguments{
\item{filepath}{Character. Path to the netCDF file.}

\item{attribute_name}{Character. Name of the attribute that should be
changed.}

\item{value}{New value that should be assigned to the attribute.}

\item{levelpath}{Character. Default: NULL. Indicates the location of the
attribute. The default means that the attribute is located at a global
level. If the attribute is located at the datacubelevel just add the
datacubepath, e.g. metric_1/ebv_cube. For the metric level the value may be 'metric_1' or
'scenario_1/metric_1'. This path depends on whether the netCDF hierarchy
has scenarios or not.}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Adds the new value to the attribute. Check your results using
\code{\link[=ebv_properties]{ebv_properties()}}.
}
\description{
Write a new attribute value to an EBV netCDF. Not all attributes
can be changed. Some are always created automatically, e.g. the attributes
belonging to the crs, time and var_entity datasets. In this case you have
to re-create the netCDF file.
}
\note{
You can change the ebv_class and the ebv_name. In this case you need to
change the ebv_class first. Don't forget to change the ebv_name accordingly!
}
\examples{
#set path to EBV netCDF file <-
system.file(file.path("extdata","baisero_spepop_id5_20220405_v1_empty.nc"),
package="ebvcube")

\dontrun{
try({
#change the standard_name of the metric
attribute1 <- 'standard_name'
value1 <- 'habitat availability'
level1 <- 'scenario_1/metric_1'
ebv_attribute(filepath = file, attribute_name = attribute1,
              value = value1, level = level1)

#change the units of the ebv_cube
attribute2 <- 'units'
value2 <- 'Land-use of 5,090 mammals calculated in sqkm'
level2 <- 'scenario_1/metric_1/ebv_cube' #equal to the datacubepath
ebv_attribute(filepath = file, attribute_name = attribute2,
              value = value2, level = level2)

#change the name of the creator at the global level
attribute3 <- 'creator_name'
value3 <- 'Jane Doe'
ebv_attribute(filepath = file, attribute_name = attribute3,
              value = value3)
}, TRUE)
}
}
