% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecap.R
\name{ecap}
\alias{ecap}
\title{Estimate parameters for the ECAP adjustment}
\usage{
ecap(
  unadjusted_prob,
  win_var,
  win_id,
  bias_indicator = F,
  lambda_grid = 10^seq(-6, 0, by = 0.5),
  gamma_grid = seq(0.001, 0.05, by = 0.001),
  theta_grid = seq(-4, 2, 0.1)
)
}
\arguments{
\item{unadjusted_prob}{Numeric vector of probability estimates that you want estimate the ECAP parameters from.}

\item{win_var}{A binary vector of wins and losses that correspond to the probabilities in the unadjusted_prob vector}

\item{win_id}{A value that denotes a "win" (or if the event occurred) in the win_var vector.}

\item{bias_indicator}{Set this equal to F if you don't want to consider bias in your estimation. Set it equal to T if you do.}

\item{lambda_grid}{This is already predefined. However, you can adjust the grid of tuning parameters lambda that ECAP searches over if needed.}

\item{gamma_grid}{This is already predefined. However, you can adjust the grid of gamma that ECAP searches over if needed.}

\item{theta_grid}{This is already predefined. However, you can adjust the grid of theta that ECAP searches over if needed.}
}
\value{
An ecap object that can be used to adjust new probability estimates. It contains all of the tuning parameters needed to calibrate
ECAP as well as diagnostic information on the estimate of g. The probabilities used to calibrate ECAP have also been ECAP corrected and
are given as part of the output.
}
\description{
This function estimates 3 parameters that are needed to preform the ECAP adjustment. As such, it is meant to be used
together with the predict.ecap() function included in the "ecap" package. The parameters estimated are the level of corruption
and bias in the given unadjusted probability estimates, along with a tuning parameter needed to adjust the level of
smoothness in the ECAP estimation.
}
\examples{
\donttest{
set.seed(1)
p_obs <- runif(1000, 0, 1)
win_var <- rbinom(length(p_obs), 1, p_obs)
ecap_fit <- ecap(unadjusted_prob = p_obs, win_var = win_var, win_id = 1, bias_indicator = FALSE)
}
}
\references{
http://faculty.marshall.usc.edu/gareth-james/Research/Probs.pdf
}
\author{
Bradley Rava, Peter Radchenko and Gareth M. James.
}
