% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-solve-trig-generic.R
\docType{methods}
\name{solve_trig.ecd}
\alias{solve_trig.ecd}
\alias{solve_trig}
\alias{solve_trig,ecd-method}
\title{Trigonometric solution for a elliptic curve}
\usage{
\method{solve_trig}{ecd}(object, x)

solve_trig(object, x)

\S4method{solve_trig}{ecd}(object, x)
}
\arguments{
\item{object}{an object of ecd class}

\item{x}{array of x dimension}
}
\value{
array of y
}
\description{
Use Chebyshev trigonometry for a depressed cube to solve a elliptic curve \eqn{y(x)}.
}
\examples{
d <- ecd()
x <- seq(-100,100,by=0.1)
y <- solve_trig(d,x)
}
\author{
Stephen H-T. Lihn
}
\keyword{solve}
