% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-fit-data-method.R
\name{ecd.fit_data}
\alias{ecd.fit_data}
\title{Sample data fit}
\usage{
ecd.fit_data(
  symbol = "dji",
  iter = 1000,
  FIT = FALSE,
  EPS = FALSE,
  conf_file = "conf/ecd-fit-conf.yml",
  eps_file = NULL,
  qa.fit = FALSE
)
}
\arguments{
\item{symbol}{Character. The symbol of sample data. Default: dji.}

\item{iter}{A length-one numeric. Number of maximum iterations. Default: 1000.}

\item{FIT}{Logical, indicating whether to call linear regression, default = FALSE}

\item{EPS}{Logical, indicating whether to save the plot to EPS, default = FALSE}

\item{conf_file}{File name fof symbol config, default to conf/ecd-fit-conf.yml}

\item{eps_file}{File name for eps output}

\item{qa.fit}{Logical, qa the standardfit_fn once.}
}
\value{
Final ecd object
}
\description{
Fitting sample data to ecd with a starting set of parameters.
This is the highest level wrapper of the fitting routine.
}
\examples{
\dontrun{
dji <- ecd.fit_data("dji", FIT=T)
}
}
\keyword{fit}
\keyword{sample-data}
