% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_sunburst}
\alias{e_sunburst}
\alias{e_sunburst_}
\title{Sunburst}
\usage{
e_sunburst(e, parent, child, value, itemStyle, rm_x = TRUE,
  rm_y = TRUE, ...)

e_sunburst_(e, parent, child, value, itemStyle = NULL, rm_x = TRUE,
  rm_y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{parent, child}{Edges.}

\item{value}{Name of column containing values.}

\item{itemStyle}{Name of column containing styles to pass to \code{child}, 
expects a \code{data.frame} or a \code{list}, see details.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Build a sunburst.
}
\details{
The \code{itemStyle} argument essentially is a nested data.frame with column names such as
\code{color}, or \code{borderColor} as specified in the 
\href{https://echarts.apache.org/en/option.html#series-sunburst.data.itemStyle}{official documentation}.
}
\examples{
df <- data.frame(
  parent = c("earth", "earth", "earth", "mars", "mars"), 
  child = c("forest", "ocean", "iceberg", "elon", "curiosity"),
  value = ceiling(rnorm(5, 10, 2))
)

df \%>\% 
  e_charts() \%>\% 
  e_sunburst(parent, child, value) \%>\% 
  e_theme("westeros")
  
# with itemStyle
colors <- c("red", "black", "blue")

df$color <- sample(colors, 5, replace = TRUE)
df$borderColor <- sample(colors, 5, replace = TRUE)

df \%>\% 
  tidyr::nest(color, borderColor, .key = "style") \%>\% # nest
  e_charts() \%>\% 
  e_sunburst(parent, child, value, style) 

}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-sunburst}{Additional arguments}
}
