% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{e_geo}
\alias{e_geo}
\title{Geo}
\usage{
e_geo(e, map = "world", ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{map}{Map type.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Initialise geo.
}
\examples{
flights <- read.csv(
  paste0("https://raw.githubusercontent.com/plotly/datasets/",
         "master/2011_february_aa_flight_paths.csv")
)

flights \%>\% 
  e_charts() \%>\% 
  e_geo() \%>\% 
  e_lines(
    start_lon, 
    start_lat, 
    end_lon, 
    end_lat,
    name = "flights",
    lineStyle = list(normal = list(curveness = 0.3))
   )

}
\seealso{
\href{https://echarts.apache.org/en/option.html#geo}{Additional arguments}
}
